/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.block.WSBlock;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntity;
import com.degoos.wetsponge.block.tileentity.WSTileEntity;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.mixin.sponge.interfaces.WSMixinChunk;
import com.degoos.wetsponge.parser.entity.SpongeEntityParser;
import com.degoos.wetsponge.parser.world.WorldParser;
import com.degoos.wetsponge.world.SpongeLocation;
import com.degoos.wetsponge.world.SpongeWorld;
import com.degoos.wetsponge.world.WSChunk;
import com.degoos.wetsponge.world.WSWorld;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.api.world.Chunk;

public class SpongeChunk
implements WSChunk {
    private Chunk chunk;

    public SpongeChunk(Chunk chunk) {
        this.chunk = chunk;
    }

    @Override
    public WSWorld getWorld() {
        return WorldParser.getOrCreateWorld(this.chunk.getWorld().getName(), this.chunk.getWorld());
    }

    @Override
    public int getX() {
        return this.chunk.getBlockMin().getX() / 16;
    }

    @Override
    public int getZ() {
        return this.chunk.getBlockMin().getZ() / 16;
    }

    @Override
    public WSBlock getBlock(int x, int y, int z) {
        return new SpongeLocation(this.chunk.getWorld(), (double)(this.chunk.getBlockMin().getX() + x), (double)y, (double)(this.chunk.getBlockMin().getZ() + z), 0.0f, 0.0f).getBlock();
    }

    @Override
    public Set<WSEntity> getEntities() {
        return this.chunk.getEntities().stream().map(SpongeEntityParser::getWSEntity).collect(Collectors.toSet());
    }

    @Override
    public Set<WSTileEntity> getTileEntities() {
        return this.chunk.getTileEntities().stream().map(SpongeTileEntity::new).collect(Collectors.toSet());
    }

    @Override
    public boolean load(boolean generate) {
        return this.chunk.loadChunk(generate);
    }

    @Override
    public void addToUnloadQueue() {
        ((SpongeWorld)this.getWorld()).getChunkProvider().func_189549_a((net.minecraft.world.chunk.Chunk)this.chunk);
    }

    @Override
    public boolean isLoaded() {
        return this.chunk.isLoaded();
    }

    @Override
    public boolean canBeUnloaded() {
        return ((WSMixinChunk)this.chunk).canBeUnloaded();
    }

    @Override
    public void setCanBeUnloaded(boolean canBeUnloaded) {
        ((WSMixinChunk)this.chunk).setCanBeUnloaded(canBeUnloaded);
    }

    @Override
    public boolean canBeSaved() {
        return ((WSMixinChunk)this.chunk).canBeSaved();
    }

    @Override
    public void setCanBeSaved(boolean canSave) {
        ((WSMixinChunk)this.chunk).setCanBeSaved(canSave);
    }

    public Chunk getHandled() {
        return this.chunk;
    }
}

