/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.block.SpigotBlock;
import com.degoos.wetsponge.block.WSBlock;
import com.degoos.wetsponge.block.tileentity.SpigotTileEntity;
import com.degoos.wetsponge.block.tileentity.WSTileEntity;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.listener.spigot.SpigotWorldListener;
import com.degoos.wetsponge.parser.entity.SpigotEntityParser;
import com.degoos.wetsponge.parser.world.WorldParser;
import com.degoos.wetsponge.util.reflection.SpigotHandledUtils;
import com.degoos.wetsponge.world.WSChunk;
import com.degoos.wetsponge.world.WSWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Chunk;

public class SpigotChunk
implements WSChunk {
    private Chunk chunk;

    public SpigotChunk(Chunk chunk) {
        this.chunk = chunk;
    }

    @Override
    public WSWorld getWorld() {
        return WorldParser.getOrCreateWorld(this.chunk.getWorld().getName(), this.chunk.getWorld());
    }

    @Override
    public int getX() {
        return this.chunk.getX();
    }

    @Override
    public int getZ() {
        return this.chunk.getZ();
    }

    @Override
    public WSBlock getBlock(int x, int y, int z) {
        return new SpigotBlock(this.chunk.getBlock(x, y, z));
    }

    @Override
    public Set<WSEntity> getEntities() {
        return Arrays.stream(this.chunk.getEntities()).map(SpigotEntityParser::getWSEntity).collect(Collectors.toSet());
    }

    @Override
    public Set<WSTileEntity> getTileEntities() {
        return Arrays.stream(this.chunk.getTileEntities()).map(SpigotTileEntity::new).collect(Collectors.toSet());
    }

    @Override
    public boolean load(boolean generate) {
        return this.chunk.load(generate);
    }

    @Override
    public void addToUnloadQueue() {
        Object chunkProvider = this.getWorld().getChunkProvider();
        try {
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                Object chunkHandled = SpigotHandledUtils.getHandle(this.chunk);
                chunkProvider.getClass().getMethod("unload", chunkHandled.getClass()).invoke(chunkProvider, chunkHandled);
            } else {
                chunkProvider.getClass().getMethod("queueUnload", Integer.TYPE, Integer.TYPE).invoke(chunkProvider, this.getX(), this.getZ());
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.chunk.isLoaded();
    }

    @Override
    public boolean canBeUnloaded() {
        return !SpigotWorldListener.dontUnloadChunks.contains(this.chunk);
    }

    @Override
    public void setCanBeUnloaded(boolean canBeUnloaded) {
        if (canBeUnloaded) {
            SpigotWorldListener.dontUnloadChunks.remove(this.chunk);
        } else {
            SpigotWorldListener.dontUnloadChunks.add(this.chunk);
        }
    }

    @Override
    public boolean canBeSaved() {
        Object object = this.getWorld().getChunkProvider();
        try {
            return !this.getList("getCantSave", object).contains(SpigotHandledUtils.getHandle(this.chunk));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return true;
        }
    }

    @Override
    public void setCanBeSaved(boolean canSave) {
        Object object = this.getWorld().getChunkProvider();
        try {
            if (canSave) {
                this.getList("getCantSave", object).remove(SpigotHandledUtils.getHandle(this.chunk));
            } else {
                this.getList("getCantSave", object).add(SpigotHandledUtils.getHandle(this.chunk));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public Chunk getHandled() {
        return this.chunk;
    }

    public Object getBukkitHandled() {
        return SpigotHandledUtils.getHandle(this.chunk);
    }

    private ArrayList getList(String getterName, Object object) throws Exception {
        return (ArrayList)object.getClass().getMethod(getterName, new Class[0]).invoke(object, new Object[0]);
    }
}

