/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.enums.EnumDifficulty;
import com.degoos.wetsponge.enums.EnumGameMode;
import com.degoos.wetsponge.world.Spigot13Location;
import com.degoos.wetsponge.world.WSWorldProperties;
import com.flowpowered.math.vector.Vector3i;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Difficulty;
import org.bukkit.World;

public class Spigot13WorldProperties
implements WSWorldProperties {
    private World world;

    public Spigot13WorldProperties(World world) {
        this.world = world;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public String getWorldName() {
        return this.world.getName();
    }

    @Override
    public UUID getUniqueId() {
        return this.world.getUID();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean loadOnStartup() {
        return false;
    }

    @Override
    public void setLoadOnStartup(boolean loadOnStartup) {
    }

    @Override
    public boolean doesKeepSpawnLoaded() {
        return this.world.getKeepSpawnInMemory();
    }

    @Override
    public void setKeepSpawnLoaded(boolean keepSpawnLoaded) {
        this.world.setKeepSpawnInMemory(keepSpawnLoaded);
    }

    @Override
    public boolean doesGenerateSpawnOnLoad() {
        return false;
    }

    @Override
    public void setGenerateSpawnOnLoad(boolean generateSpawnOnLoad) {
    }

    @Override
    public Vector3i getSpawnPosition() {
        return new Spigot13Location(this.world.getSpawnLocation()).toVector3i();
    }

    @Override
    public void setSpawnPosition(Vector3i spawnPosition) {
        this.world.setSpawnLocation(spawnPosition.getX(), spawnPosition.getY(), spawnPosition.getZ());
    }

    @Override
    public long getSeed() {
        return this.world.getSeed();
    }

    @Override
    public void setSeed(long seed) {
    }

    @Override
    public long getTotalTime() {
        return this.world.getFullTime();
    }

    @Override
    public long getWorldTime() {
        return this.world.getTime();
    }

    @Override
    public void setWorldTime(long worldTime) {
        this.world.setTime(worldTime);
    }

    @Override
    public boolean isPVPEnabled() {
        return this.world.getPVP();
    }

    @Override
    public void setPVPEnabled(boolean pvpEnabled) {
        this.world.setPVP(pvpEnabled);
    }

    @Override
    public boolean isRaining() {
        return this.world.hasStorm();
    }

    @Override
    public void setRaining(boolean raining) {
        this.world.setStorm(raining);
    }

    @Override
    public int getRainTime() {
        return this.world.getWeatherDuration();
    }

    @Override
    public void setRainTime(int rainTime) {
        this.world.setWeatherDuration(rainTime);
    }

    @Override
    public boolean isThundering() {
        return this.world.isThundering();
    }

    @Override
    public void setThundering(boolean thundering) {
        this.world.setThundering(thundering);
    }

    @Override
    public int getThunderTime() {
        return this.world.getThunderDuration();
    }

    @Override
    public void setThunderTime(int thunderTime) {
        this.world.setThunderDuration(thunderTime);
    }

    @Override
    public EnumGameMode getGameMode() {
        return EnumGameMode.SURVIVAL;
    }

    @Override
    public void setGameMode(EnumGameMode gameMode) {
    }

    @Override
    public boolean usesMapFeatures() {
        return false;
    }

    @Override
    public void setMapFeaturesEnabled(boolean mapFeaturesEnabled) {
    }

    @Override
    public boolean isHardcore() {
        return false;
    }

    @Override
    public void setHardcore(boolean hardcore) {
    }

    @Override
    public boolean areCommandsAllowed() {
        return false;
    }

    @Override
    public void setCommandsAllowed(boolean commandsAllowed) {
    }

    @Override
    public EnumDifficulty getDifficulty() {
        return EnumDifficulty.getByValue(this.world.getDifficulty().getValue()).orElse(EnumDifficulty.NORMAL);
    }

    @Override
    public void setDifficulty(EnumDifficulty difficulty) {
        this.world.setDifficulty(Difficulty.getByValue((int)difficulty.getValue()));
    }

    @Override
    public boolean doesGenerateBonusChest() {
        return false;
    }

    @Override
    public Optional<String> getGameRule(String name) {
        return Optional.ofNullable(this.world.getGameRuleValue(name));
    }

    @Override
    public Map<String, String> getGameRules() {
        HashMap<String, String> gameRules = new HashMap<String, String>();
        for (String gameRule : this.world.getGameRules()) {
            String value = this.world.getGameRuleValue(gameRule);
            if (value == null) continue;
            gameRules.put(gameRule, value);
        }
        return gameRules;
    }

    @Override
    public void setGameRule(String name, String value) {
        this.world.setGameRuleValue(name, value);
    }

    @Override
    public boolean removeGameRule(String name) {
        return this.world.setGameRuleValue(name, null);
    }

    @Override
    public int getMaxHeight() {
        return this.world.getMaxHeight();
    }
}

