/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.world.WSWorldBorder;
import com.flowpowered.math.vector.Vector2d;
import org.bukkit.Location;
import org.bukkit.WorldBorder;

public class Spigot13WorldBorder
implements WSWorldBorder {
    private WorldBorder worldBorder;

    public Spigot13WorldBorder(WorldBorder worldBorder) {
        this.worldBorder = worldBorder;
    }

    @Override
    public void copyPropertiesFrom(WSWorldBorder worldBorder) {
        worldBorder.setCenter(this.getCenter());
        worldBorder.setDamageAmount(this.getDamageAmount());
        worldBorder.setDamageThreshold(this.getDamageThreshold());
        worldBorder.setDiameter(this.getDiameter());
        worldBorder.setWarningDistance(this.getWarningDistance());
        worldBorder.setWaningTime(this.getWarningTime());
    }

    @Override
    public Vector2d getCenter() {
        Location location = this.worldBorder.getCenter();
        return new Vector2d(location.getX(), location.getZ());
    }

    @Override
    public void setCenter(Vector2d center) {
        this.worldBorder.setCenter(center.getX(), center.getY());
    }

    @Override
    public void setCenter(double x, double z) {
        this.worldBorder.setCenter(x, z);
    }

    @Override
    public double getDamageAmount() {
        return this.worldBorder.getDamageAmount();
    }

    @Override
    public void setDamageAmount(double damageAmount) {
        this.worldBorder.setDamageAmount(damageAmount);
    }

    @Override
    public double getDamageThreshold() {
        return this.worldBorder.getDamageBuffer();
    }

    @Override
    public void setDamageThreshold(double damageThreshold) {
        this.worldBorder.setDamageBuffer(damageThreshold);
    }

    @Override
    public double getDiameter() {
        return this.worldBorder.getSize();
    }

    @Override
    public void setDiameter(double diameter) {
        this.setDiameter(this.getDiameter(), diameter, 0L);
    }

    @Override
    public void setDiameter(double diameter, long time) {
        this.setDiameter(this.getDiameter(), diameter, time);
    }

    @Override
    public void setDiameter(double startDiameter, double endDiameter, long time) {
        try {
            Object handled = ReflectionUtils.getObject(this.getHandled(), "handle");
            ReflectionUtils.invokeMethod(handled, "transitionSizeBetween", Math.min(6.0E7, Math.max(1.0, startDiameter)), Math.min(6.0E7, Math.max(1.0, endDiameter)), Math.min(9223372036854775L, Math.max(0L, time)));
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error had occurred while WetSponge was trying to set the diameter of a WorldBorder!");
        }
    }

    @Override
    public double getNewDiameter() {
        try {
            Object handled = ReflectionUtils.getObject(this.getHandled(), "handle");
            return (Double)ReflectionUtils.invokeMethod(handled, "j", new Object[0]);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error had occurred while WetSponge was trying to set the diameter of a WorldBorder!");
            return 0.0;
        }
    }

    @Override
    public int getWarningDistance() {
        return this.worldBorder.getWarningDistance();
    }

    @Override
    public void setWarningDistance(int warningDistance) {
        this.worldBorder.setWarningDistance(warningDistance);
    }

    @Override
    public int getWarningTime() {
        return this.worldBorder.getWarningTime();
    }

    @Override
    public void setWaningTime(int waningTime) {
        this.worldBorder.setWarningTime(waningTime);
    }

    public WorldBorder getHandled() {
        return this.worldBorder;
    }
}

