/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.block.Spigot13Block;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumBiomeType;
import com.degoos.wetsponge.listener.spigot.Spigot13WorldListener;
import com.degoos.wetsponge.parser.entity.Spigot13EntityParser;
import com.degoos.wetsponge.parser.world.WorldParser;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.NumericUtils;
import com.degoos.wetsponge.world.Spigot13World;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import com.flowpowered.math.vector.Vector2f;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.NumberConversions;

public class Spigot13Location
implements WSLocation {
    public static Map<String, List<Spigot13Location>> locations = new HashMap<String, List<Spigot13Location>>();
    private String worldName;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private Location bukkitLocation;
    private World bukkitWorld;

    public Spigot13Location(String worldName, double x, double y, double z, float yaw, float pitch) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.bukkitWorld = Spigot13WorldListener.getWorld(worldName.toLowerCase()).orElse(null);
        this.putInMap();
    }

    public Spigot13Location(World world, double x, double y, double z, float yaw, float pitch) {
        this.worldName = world.getName();
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.bukkitWorld = Spigot13WorldListener.getWorld(this.worldName.toLowerCase()).orElse(null);
        this.putInMap();
    }

    public Spigot13Location(Location location) {
        this.worldName = location.getWorld().getName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.bukkitWorld = location.getWorld();
        this.putInMap();
    }

    public Spigot13Location(WSLocation location) {
        this.worldName = location.getWorldName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.bukkitWorld = Spigot13WorldListener.getWorld(this.worldName.toLowerCase()).orElse(null);
        this.putInMap();
    }

    public Spigot13Location(String string) {
        String[] sl = string.split(";");
        if (NumericUtils.isDouble(sl[0])) {
            this.worldName = sl[5];
            this.x = Double.parseDouble(sl[0]);
            this.y = Double.parseDouble(sl[1]);
            this.z = Double.parseDouble(sl[2]);
            this.pitch = Float.parseFloat(sl[3]);
            this.yaw = Float.parseFloat(sl[4]);
        } else {
            this.worldName = sl[0];
            this.x = Double.parseDouble(sl[1]);
            this.y = Double.parseDouble(sl[2]);
            this.z = Double.parseDouble(sl[3]);
            this.yaw = Float.parseFloat(sl[4]);
            this.pitch = Float.parseFloat(sl[5]);
        }
        this.bukkitWorld = Spigot13WorldListener.getWorld(this.worldName.toLowerCase()).orElse(null);
        this.putInMap();
    }

    public Spigot13Location(Player player) {
        Location location = player.getLocation();
        this.worldName = location.getWorld().getName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.bukkitWorld = location.getWorld();
        this.putInMap();
    }

    private void putInMap() {
        if (locations.containsKey(this.worldName)) {
            locations.get(this.worldName).add(this);
        } else {
            ArrayList<Spigot13Location> list = new ArrayList<Spigot13Location>();
            list.add(this);
            locations.put(this.worldName, list);
        }
        if (this.bukkitWorld != null) {
            this.bukkitLocation = new Location(this.bukkitWorld, this.x, this.y, this.z, this.yaw, this.pitch);
        }
    }

    @Override
    public String toString() {
        return this.worldName + ";" + this.x + ";" + this.y + ";" + this.z + ";" + this.yaw + ";" + this.pitch;
    }

    public Location getLocation() {
        this.bukkitWorld = Spigot13WorldListener.getWorld(this.worldName.toLowerCase()).orElse(null);
        if (this.bukkitWorld != null && this.bukkitLocation == null) {
            this.bukkitLocation = new Location(this.bukkitWorld, this.x, this.y, this.z, this.yaw, this.pitch);
        }
        if (this.bukkitWorld == null) {
            InternalLogger.sendError("ERROR: world " + this.worldName + " doesn't exist!");
            return new Location((World)Bukkit.getWorlds().get(0), this.x, this.y, this.z, this.yaw, this.pitch);
        }
        return this.bukkitLocation.clone();
    }

    @Override
    public Spigot13Block getBlock() {
        return new Spigot13Block(this.getLocation().getBlock());
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public Spigot13Location setWorldName(String worldName) {
        locations.get(this.worldName).remove(this);
        this.worldName = worldName;
        this.bukkitWorld = Spigot13WorldListener.getWorld(worldName.toLowerCase()).orElse(null);
        this.putInMap();
        return this;
    }

    @Override
    public Spigot13World getWorld() {
        this.bukkitWorld = Spigot13WorldListener.getWorld(this.worldName.toLowerCase()).orElse(null);
        return (Spigot13World)WorldParser.getOrCreateWorld(this.bukkitWorld.getName(), this.bukkitWorld);
    }

    @Override
    public WSLocation setWorld(WSWorld world) {
        this.setWorldName(world.getName());
        return this;
    }

    @Override
    public WSLocation updateWorld() {
        this.bukkitWorld = Spigot13WorldListener.getWorld(this.worldName.toLowerCase()).orElse(null);
        if (this.bukkitLocation != null) {
            this.bukkitLocation.setWorld(this.bukkitWorld);
        } else {
            this.bukkitLocation = new Location(this.bukkitWorld, this.x, this.y, this.z, this.yaw, this.pitch);
        }
        return this;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public Spigot13Location setX(double x) {
        this.x = x;
        if (this.bukkitLocation != null) {
            this.bukkitLocation.setX(x);
        }
        return this;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public Spigot13Location setY(double y) {
        this.y = y;
        if (this.bukkitLocation != null) {
            this.bukkitLocation.setY(y);
        }
        return this;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public Spigot13Location setZ(double z) {
        this.z = z;
        if (this.bukkitLocation != null) {
            this.bukkitLocation.setZ(z);
        }
        return this;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public Spigot13Location setYaw(float yaw) {
        this.yaw = yaw;
        if (this.bukkitLocation != null) {
            this.bukkitLocation.setYaw(yaw);
        }
        return this;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    public Spigot13Location setPitch(float pitch) {
        this.pitch = pitch;
        if (this.bukkitLocation != null) {
            this.bukkitLocation.setPitch(pitch);
        }
        return this;
    }

    @Override
    public Vector2f getRotation() {
        return new Vector2f(this.pitch, this.yaw);
    }

    @Override
    public WSLocation setRotation(Vector2f rotation) {
        this.pitch = rotation.getX();
        this.yaw = rotation.getY();
        return this;
    }

    @Override
    public int getBlockX() {
        return NumberConversions.floor((double)this.x);
    }

    @Override
    public int getBlockY() {
        return NumberConversions.floor((double)this.y);
    }

    @Override
    public int getBlockZ() {
        return NumberConversions.floor((double)this.z);
    }

    @Override
    public double distance(WSLocation location) {
        return Math.sqrt(Math.pow(location.getX() - this.x, 2.0) + Math.pow(location.getY() - this.y, 2.0) + Math.pow(location.getZ() - this.z, 2.0));
    }

    public double distance(Location location) {
        return Math.sqrt(Math.pow(location.getX() - this.x, 2.0) + Math.pow(location.getY() - this.y, 2.0) + Math.pow(location.getZ() - this.z, 2.0));
    }

    @Override
    public double distance(double x, double y, double z) {
        return Math.sqrt(Math.pow(x - this.x, 2.0) + Math.pow(y - this.y, 2.0) + Math.pow(z - this.z, 2.0));
    }

    @Override
    public double distance(Vector3d vector3d) {
        return this.distance(vector3d.getX(), vector3d.getY(), vector3d.getZ());
    }

    @Override
    public Spigot13Location add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        if (this.bukkitLocation != null) {
            this.bukkitLocation.add(x, y, z);
        }
        return this;
    }

    @Override
    public WSLocation add(Vector3d vector3d) {
        return this.add(vector3d.getX(), vector3d.getY(), vector3d.getZ());
    }

    public Set<Entity> getEntitiesOnBlock() {
        if (this.bukkitWorld == null) {
            return new HashSet<Entity>();
        }
        return this.bukkitWorld.getEntities().stream().filter(entity -> new Spigot13Location(entity.getLocation()).equalsBlock(this)).collect(Collectors.toSet());
    }

    public <T extends Entity> Set<T> getEntitiesOnBlock(Class<T> entityType) {
        if (this.bukkitWorld == null) {
            return new HashSet();
        }
        HashSet set = new HashSet();
        this.bukkitWorld.getEntities().stream().filter(entity -> entityType.isInstance(entity) && new Spigot13Location(entity.getLocation()).equalsBlock(this)).forEach(entity -> set.add(entity));
        return set;
    }

    @Override
    public Spigot13Location clone() {
        return new Spigot13Location(this);
    }

    @Override
    public Spigot13Location getBlockLocation() {
        return new Spigot13Location(this.worldName, (double)this.getBlockX(), (double)this.getBlockY(), (double)this.getBlockZ(), 0.0f, 0.0f);
    }

    @Override
    public EnumBiomeType getBiome() {
        return this.getWorld().getBiome(this.getBlockX(), this.getBlockY(), this.getBlockZ());
    }

    @Override
    public void setBiome(EnumBiomeType biome) {
        this.getWorld().setBiome(this.getBlockX(), this.getBlockY(), this.getBlockZ(), biome);
    }

    @Override
    public Collection<WSEntity> getNearbyEntities(Vector3d radius) {
        return this.bukkitWorld.getNearbyEntities(this.bukkitLocation, radius.getX(), radius.getY(), radius.getZ()).stream().map(Spigot13EntityParser::getWSEntity).collect(Collectors.toList());
    }

    public Set<WSEntity> getNearbyEntities(double radius) {
        if (this.bukkitWorld == null) {
            return new HashSet<WSEntity>();
        }
        return this.bukkitWorld.getEntities().stream().filter(entity -> this.distance(entity.getLocation()) <= radius).map(Spigot13EntityParser::getWSEntity).collect(Collectors.toSet());
    }

    @Override
    public <T extends WSEntity> Collection<T> getNearbyEntities(Vector3d radius, Class<T> entityType) {
        if (this.bukkitWorld == null) {
            return new HashSet();
        }
        HashSet set = new HashSet();
        this.bukkitWorld.getEntities().stream().map(Spigot13EntityParser::getWSEntity).filter(entity -> {
            WSLocation location = entity.getLocation();
            return entityType.isInstance(entity) && Math.abs(location.getX() - this.x) < radius.getX() && Math.abs(location.getY() - this.y) < radius.getY() && Math.abs(location.getZ() - this.z) < radius.getZ();
        }).forEach(entity -> set.add(entity));
        return set;
    }

    @Override
    public <T extends WSEntity> Collection<T> getNearbyEntities(double radius, Class<T> entityType) {
        if (this.bukkitWorld == null) {
            return new HashSet();
        }
        HashSet set = new HashSet();
        this.bukkitWorld.getEntities().stream().map(Spigot13EntityParser::getWSEntity).filter(entity -> entityType.isInstance(entity) && this.distance(entity.getLocation()) <= radius).forEach(entity -> set.add(entity));
        return set;
    }

    @Override
    public Collection<WSPlayer> getNearbyPlayers(Vector3d radius) {
        return this.getNearbyEntities(radius).stream().filter(entity -> entity instanceof Player).map(entity -> (WSPlayer)entity).collect(Collectors.toList());
    }

    @Override
    public Collection<WSPlayer> getNearbyPlayers(double radius) {
        return this.getNearbyEntities(radius).stream().filter(entity -> entity instanceof Player).map(entity -> (WSPlayer)entity).collect(Collectors.toList());
    }

    @Override
    public int getHighestY() {
        return this.bukkitWorld.getHighestBlockYAt(this.getBlockX(), this.getBlockZ());
    }

    @Override
    public WSLocation updateSign(String[] lines) {
        if (lines.length != 4) {
            return this;
        }
        if (this.bukkitWorld == null) {
            this.getLocation();
        }
        if (this.bukkitWorld == null) {
            return this;
        }
        Block block = this.bukkitWorld.getBlockAt((int)this.x, (int)this.y, (int)this.z);
        if (block == null || !(block.getState() instanceof Sign)) {
            return this;
        }
        Sign sign = (Sign)block.getState();
        for (int i = 0; i < 4; ++i) {
            sign.setLine(i, lines[i]);
        }
        sign.update(true);
        return this;
    }

    @Override
    public boolean equalsBlock(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spigot13Location that = (Spigot13Location)o;
        return this.getBlockX() == that.getBlockX() && this.getBlockY() == that.getBlockY() && this.getBlockZ() == that.getBlockZ();
    }

    @Override
    public Vector3d getFacingDirection() {
        double xz = Math.cos(Math.toRadians(this.pitch));
        return new Vector3d(-xz * Math.sin(Math.toRadians(this.yaw)), -Math.sin(Math.toRadians(this.pitch)), xz * Math.cos(Math.toRadians(this.yaw)));
    }

    @Override
    public Vector3d toVector3d() {
        return new Vector3d(this.x, this.y, this.z);
    }

    @Override
    public Vector3i toVector3i() {
        return new Vector3i(this.getBlockX(), this.getBlockY(), this.getBlockZ());
    }

    @Override
    public Object getHandledWorld() {
        return this.bukkitWorld;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spigot13Location that = (Spigot13Location)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && Float.compare(that.yaw, this.yaw) == 0 && Float.compare(that.pitch, this.pitch) == 0 && (this.worldName != null ? this.worldName.equals(that.worldName) : that.worldName == null);
    }

    public int hashCode() {
        int result = this.worldName != null ? this.worldName.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.yaw != 0.0f ? Float.floatToIntBits(this.yaw) : 0);
        result = 31 * result + (this.pitch != 0.0f ? Float.floatToIntBits(this.pitch) : 0);
        return result;
    }
}

