/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.util.reflection;

import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;

public class SpigotTextUtils {
    private static final Pattern url = Pattern.compile("^(?:(https?)://)?([-\\w_\\.]{2,}\\.[a-z]{2,4})(/\\S*)?$");
    private static Class<?> clazz = NMSUtils.getNMSClass("IChatBaseComponent");

    public static String toJSON(Object iChatBaseComponent) {
        try {
            return (String)NMSUtils.getNMSClass("IChatBaseComponent").getDeclaredClasses()[0].getMethod("a", clazz).invoke(null, iChatBaseComponent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object toIChatBaseComponentFromJSON(String json) {
        try {
            return NMSUtils.getNMSClass("IChatBaseComponent").getDeclaredClasses()[0].getMethod("a", String.class).invoke(null, json);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was creating a IChatBaseComponent!");
            return null;
        }
    }

    public static Object toIChatBaseComponentFromFormattedText(String text) {
        try {
            return NMSUtils.getNMSClass("IChatBaseComponent").getDeclaredClasses()[0].getMethod("a", String.class).invoke(null, "{\"text\":\"" + text + "\"}");
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was creating a IChatBaseComponent!");
            return null;
        }
    }

    public static BaseComponent[] fromLegacyText(String message) {
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        StringBuilder builder = new StringBuilder();
        TextComponent component = new TextComponent();
        Matcher matcher = url.matcher(message);
        for (int i = 0; i < message.length(); ++i) {
            TextComponent old;
            char c = message.charAt(i);
            if (c == '\u00a7') {
                ChatColor format;
                if (++i >= message.length()) break;
                c = message.charAt(i);
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                if ((format = ChatColor.getByChar((char)c)) == null) continue;
                if (builder.length() > 0) {
                    old = component;
                    component = new TextComponent(component);
                    old.setText(builder.toString());
                    builder = new StringBuilder();
                    components.add(old);
                }
                switch (format) {
                    case BOLD: {
                        component.setBold(Boolean.valueOf(true));
                        break;
                    }
                    case ITALIC: {
                        component.setItalic(Boolean.valueOf(true));
                        break;
                    }
                    case UNDERLINE: {
                        component.setUnderlined(Boolean.valueOf(true));
                        break;
                    }
                    case STRIKETHROUGH: {
                        component.setStrikethrough(Boolean.valueOf(true));
                        break;
                    }
                    case MAGIC: {
                        component.setObfuscated(Boolean.valueOf(true));
                        break;
                    }
                    case RESET: {
                        format = ChatColor.WHITE;
                    }
                    default: {
                        component = new TextComponent();
                        component.setColor(format);
                    }
                }
                continue;
            }
            int pos = message.indexOf(32, i);
            if (pos == -1) {
                pos = message.length();
            }
            if (matcher.region(i, pos).find()) {
                if (builder.length() > 0) {
                    old = component;
                    component = new TextComponent(component);
                    old.setText(builder.toString());
                    builder = new StringBuilder();
                    components.add(old);
                }
                old = component;
                component = new TextComponent(component);
                String urlString = message.substring(i, pos);
                component.setText(urlString);
                component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, urlString.startsWith("http") ? urlString : "http://" + urlString));
                components.add(component);
                i += pos - i - 1;
                component = old;
                continue;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            component.setText(builder.toString());
            components.add(component);
        }
        if (components.isEmpty()) {
            components.add(new TextComponent(""));
        }
        return components.toArray(new BaseComponent[components.size()]);
    }
}

