/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.util.reflection;

import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Spigot13HandledUtils {
    public static Object getWorldHandle(World w) {
        try {
            return w.getClass().getMethod("getHandle", new Class[0]).invoke((Object)w, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerHandle(Player pl) {
        return Spigot13HandledUtils.getEntityHandle((Entity)pl);
    }

    public static Object getEntityHandle(Entity entity) {
        try {
            return entity.getClass().getMethod("getHandle", new Class[0]).invoke((Object)entity, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getServerHandle(Object object) {
        try {
            return object.getClass().getMethod("getServer", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getHandle(Object object) {
        try {
            return object.getClass().getMethod("getHandle", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getBlockPosition(Location loc) {
        return Spigot13HandledUtils.getBlockPosition(loc.getX(), loc.getY(), loc.getZ());
    }

    public static Object getBlockPosition(Vector3d loc) {
        return Spigot13HandledUtils.getBlockPosition(loc.getX(), loc.getY(), loc.getZ());
    }

    public static Object getBlockPosition(Vector3i loc) {
        return Spigot13HandledUtils.getBlockPosition(loc.getX(), loc.getY(), loc.getZ());
    }

    public static Object getBlockPosition(double x, double y, double z) {
        try {
            return NMSUtils.getNMSClass("BlockPosition").getConstructor(Double.TYPE, Double.TYPE, Double.TYPE).newInstance(x, y, z);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static Object getBlockPosition(int x, int y, int z) {
        try {
            return NMSUtils.getNMSClass("BlockPosition").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(x, y, z);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static Vector3i getBlockPositionVector(Object position) {
        try {
            return new Vector3i((Integer)position.getClass().getMethod("getX", new Class[0]).invoke(position, new Object[0]), (Integer)position.getClass().getMethod("getY", new Class[0]).invoke(position, new Object[0]), (Integer)position.getClass().getMethod("getZ", new Class[0]).invoke(position, new Object[0]));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getBlockState(WSBlockType material) {
        try {
            BlockData data = ((Spigot13BlockType)material).toBlockData();
            Class<?> blockDataClass = NMSUtils.getOBCClass("block.data.CraftBlockData");
            return blockDataClass.getMethod("getState", new Class[0]).invoke((Object)data, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WSBlockType getMaterial(Object blockState) {
        try {
            Class<?> blockDataClass = NMSUtils.getOBCClass("block.data.CraftBlockData");
            Class<?> iBlockDataClass = NMSUtils.getNMSClass("IBlockData");
            BlockData blockData = (BlockData)blockDataClass.getMethod("fromData", iBlockDataClass).invoke(null, blockState);
            String id = blockData.getMaterial().getKey().toString();
            Optional<WSBlockType> optional = WSBlockTypes.getById(id);
            if (optional.isPresent()) {
                return ((Spigot13BlockType)optional.get()).readBlockData(blockData);
            }
            return new Spigot13BlockType(-1, id, id, blockData.getMaterial().getMaxStackSize());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

