/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.util.reflection;

import com.degoos.wetsponge.util.ListUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import sun.reflect.ConstructorAccessor;
import sun.reflect.FieldAccessor;
import sun.reflect.ReflectionFactory;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Class<?>[] primitiveTypes = DataType.getPrimitive(parameterTypes);
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (DataType.compare(DataType.getPrimitive(constructor.getParameterTypes()), primitiveTypes)) continue;
            return constructor;
        }
        throw new NoSuchMethodException("There is no such constructor in this class with the specified parameter types");
    }

    public static Constructor<?> getConstructor(String className, PackageType packageType, Class<?> ... parameterTypes) throws NoSuchMethodException, ClassNotFoundException {
        return ReflectionUtils.getConstructor(packageType.getClass(className), parameterTypes);
    }

    public static Field getField(Class<?> clazz, boolean declared, String fieldName) throws NoSuchFieldException, SecurityException {
        Field field = declared ? clazz.getDeclaredField(fieldName) : clazz.getField(fieldName);
        field.setAccessible(true);
        return field;
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException, SecurityException {
        Field field;
        try {
            field = clazz.getField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            field = clazz.getDeclaredField(fieldName);
        }
        field.setAccessible(true);
        return field;
    }

    public static Field getField(String className, PackageType packageType, boolean declared, String fieldName) throws NoSuchFieldException, SecurityException, ClassNotFoundException {
        return ReflectionUtils.getField(packageType.getClass(className), declared, fieldName);
    }

    public static Set<Field> getAllFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>(ListUtils.toSet(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            fields.addAll(ReflectionUtils.getAllFields(clazz.getSuperclass()));
        }
        return fields;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Class<?>[] primitiveTypes = DataType.getPrimitive(parameterTypes);
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || DataType.compare(DataType.getPrimitive(method.getParameterTypes()), primitiveTypes)) continue;
            return method;
        }
        throw new NoSuchMethodException("There is no such method in this class with the specified name and parameter types " + Arrays.toString(parameterTypes));
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) throws NoSuchMethodException {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new NoSuchMethodException("There is no such method in this class with the specified name and parameter types");
    }

    public static Object invokeConstructor(Class<?> playOutRespawn, Class<?>[] classes, Object ... params) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return playOutRespawn.getConstructor(classes).newInstance(params);
    }

    public static Method getMethod(String className, PackageType packageType, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, ClassNotFoundException {
        return ReflectionUtils.getMethod(packageType.getClass(className), methodName, parameterTypes);
    }

    public static Optional<Method> getFirstMethod(Class<?> clazz, Class<?> ... parameters) {
        Optional<Method> optional = Arrays.stream(clazz.getMethods()).filter(method -> Arrays.equals(method.getParameterTypes(), parameters)).findAny();
        if (!optional.isPresent()) {
            optional = Arrays.stream(clazz.getDeclaredMethods()).filter(method -> Arrays.equals(method.getParameterTypes(), parameters)).findAny();
        }
        return optional;
    }

    public static Optional<Method> getFirstMethodWithReturn(Class<?> clazz, Class<?> returns, Class<?> ... parameters) {
        Optional<Method> optional = Arrays.stream(clazz.getMethods()).filter(method -> method.getReturnType().equals(returns) && Arrays.equals(method.getParameterTypes(), parameters)).findAny();
        if (!optional.isPresent()) {
            optional = Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.getReturnType().equals(returns) && Arrays.equals(method.getParameterTypes(), parameters)).findAny();
        }
        return optional;
    }

    public static Object getValue(Object instance, boolean declared, String fieldName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        return ReflectionUtils.getValue(instance, instance.getClass(), declared, fieldName);
    }

    public static Object getValue(Object instance, Class<?> clazz, boolean declared, String fieldName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        return ReflectionUtils.getField(clazz, declared, fieldName).get(instance);
    }

    public static Object getValue(Object instance, String className, PackageType packageType, boolean declared, String fieldName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException {
        return ReflectionUtils.getValue(instance, packageType.getClass(className), declared, fieldName);
    }

    public static Object instantiateObject(Class<?> clazz, Object ... arguments) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        return ReflectionUtils.getConstructor(clazz, DataType.getPrimitive(arguments)).newInstance(arguments);
    }

    public static Object instantiateObject(String className, PackageType packageType, Object ... arguments) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        return ReflectionUtils.instantiateObject(packageType.getClass(className), arguments);
    }

    public static Object invokeMethod(Object instance, Class<?> clazz, String methodName, Object ... arguments) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        return ReflectionUtils.getMethod(clazz, methodName, DataType.getPrimitive(arguments)).invoke(instance, arguments);
    }

    public static Object invokeMethod(Object instance, String methodName, Object ... arguments) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        Method method = ReflectionUtils.getMethod(instance.getClass(), methodName, DataType.getPrimitive(arguments));
        method.setAccessible(true);
        return method.invoke(instance, arguments);
    }

    public static Object invokeMethod(Object instance, String className, PackageType packageType, String methodName, Object ... arguments) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        return ReflectionUtils.invokeMethod(instance, packageType.getClass(className), methodName, arguments);
    }

    public static void setValue(Object instance, boolean declared, String fieldName, Object value) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        ReflectionUtils.setValue(instance, instance.getClass(), declared, fieldName, value);
    }

    public static void setValue(Object instance, Class<?> clazz, boolean declared, String fieldName, Object value) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        ReflectionUtils.getField(clazz, declared, fieldName).set(instance, value);
    }

    public static void setValue(Object instance, String className, PackageType packageType, boolean declared, String fieldName, Object value) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException {
        ReflectionUtils.setValue(instance, packageType.getClass(className), declared, fieldName, value);
    }

    public static Object getObject(Object object, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field;
        try {
            field = object.getClass().getDeclaredField(fieldName);
        }
        catch (Exception ex) {
            field = object.getClass().getField(fieldName);
        }
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        Object obj = field.get(object);
        if (!accessible) {
            field.setAccessible(false);
        }
        return obj;
    }

    public static <T> T getFirstObject(Class<?> clazz, Class<T> objClass, Object instance) throws Exception {
        Field f = null;
        for (Field fi : clazz.getDeclaredFields()) {
            if (!fi.getType().equals(objClass)) continue;
            f = fi;
            break;
        }
        if (f == null) {
            for (Field fi : clazz.getFields()) {
                if (!fi.getType().equals(objClass)) continue;
                f = fi;
                break;
            }
        }
        f.setAccessible(true);
        return (T)f.get(instance);
    }

    public static Field getFirstField(Class<?> clazz, Class<?> objClass) throws Exception {
        Field f = null;
        for (Field fi : clazz.getDeclaredFields()) {
            if (!fi.getType().equals(objClass)) continue;
            f = fi;
            break;
        }
        if (f == null) {
            for (Field fi : clazz.getFields()) {
                if (!fi.getType().equals(objClass)) continue;
                f = fi;
                break;
            }
        }
        f.setAccessible(true);
        return f;
    }

    public static Object getStaticObject(Class<?> clazz, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = clazz.getDeclaredField(fieldName);
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        Object obj = field.get(null);
        if (!accessible) {
            field.setAccessible(false);
        }
        return obj;
    }

    public static <T> T getFirstObjectOrElse(Class<?> clazz, Class<T> objClass, Object instance, T orElse) {
        try {
            Field f = null;
            for (Field fi : clazz.getDeclaredFields()) {
                if (!fi.getType().equals(objClass)) continue;
                f = fi;
                break;
            }
            if (f == null) {
                for (Field fi : clazz.getFields()) {
                    if (!fi.getType().equals(objClass)) continue;
                    f = fi;
                    break;
                }
            }
            if (f == null) {
                return orElse;
            }
            f.setAccessible(true);
            Object object = f.get(instance);
            return (T)(object == null ? orElse : object);
        }
        catch (Throwable ex) {
            return orElse;
        }
    }

    public static void setFirstObject(Class<?> clazz, Class<?> objClass, Object instance, Object value) throws Exception {
        Field f = null;
        for (Field fi : clazz.getDeclaredFields()) {
            if (!fi.getType().equals(objClass)) continue;
            f = fi;
            break;
        }
        if (f == null) {
            for (Field fi : clazz.getFields()) {
                if (!fi.getType().equals(objClass)) continue;
                f = fi;
                break;
            }
        }
        f.setAccessible(true);
        f.set(instance, value);
    }

    public static Enum<?> getEnum(Class<?> clazz, String enumname, String constant) throws Exception {
        Enum[] econstants;
        Class<?> c = Class.forName(clazz.getName() + "$" + enumname);
        for (Enum e : econstants = (Enum[])c.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(constant)) continue;
            return e;
        }
        throw new Exception("Enum constant not found " + constant);
    }

    public static Enum<?> getEnum(Class<?> clazz, String constant) throws Exception {
        Enum[] econstants;
        Class<?> c = Class.forName(clazz.getName());
        for (Enum e : econstants = (Enum[])c.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(constant)) continue;
            return e;
        }
        throw new Exception("Enum constant not found " + constant);
    }

    public static Field setAccessible(Field field) {
        return ReflectionUtils.setAccessible(field, true);
    }

    public static Field setAccessible(Field field, boolean accessible) {
        try {
            field.setAccessible(accessible);
            if (accessible) {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                modifiersField.setAccessible(false);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return field;
    }

    public static void transferFieldData(Field field, Object from, Object to) {
        try {
            if (field.getType().equals(Byte.class) || field.getType().equals(Byte.TYPE)) {
                field.setByte(to, field.getByte(from));
            } else if (field.getType().equals(Short.class) || field.getType().equals(Short.TYPE)) {
                field.setShort(to, field.getShort(from));
            } else if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE)) {
                field.setInt(to, field.getInt(from));
            } else if (field.getType().equals(Float.class) || field.getType().equals(Float.TYPE)) {
                field.setFloat(to, field.getFloat(from));
            } else if (field.getType().equals(Long.class) || field.getType().equals(Long.TYPE)) {
                field.setLong(to, field.getLong(from));
            } else if (field.getType().equals(Double.class) || field.getType().equals(Double.TYPE)) {
                field.setDouble(to, field.getDouble(from));
            } else if (field.getType().equals(Character.class) || field.getType().equals(Character.TYPE)) {
                field.setChar(to, field.getChar(from));
            } else if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
                field.setBoolean(to, field.getBoolean(from));
            } else {
                field.set(to, field.get(from));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName) {
        Field[] fields;
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new RuntimeException("class " + enumType + " is not an instance of Enum");
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            if (!field.getName().contains("$VALUES")) continue;
            valuesField = field;
            break;
        }
        AccessibleObject.setAccessible(new Field[]{valuesField}, true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            Enum newValue = (Enum)ReflectionUtils.makeEnum(enumType, enumName, values.size(), new Class[0], new Object[0]);
            values.add(newValue);
            ReflectionUtils.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            ReflectionUtils.cleanEnumCache(enumType);
            return (T)newValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static Object makeEnum(Class<?> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws Exception {
        Object[] parms = new Object[additionalValues.length + 2];
        parms[0] = value;
        parms[1] = ordinal;
        System.arraycopy(additionalValues, 0, parms, 2, additionalValues.length);
        return enumClass.cast(ReflectionUtils.getConstructorAccessor(enumClass, additionalTypes).newInstance(parms));
    }

    private static ConstructorAccessor getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return ReflectionFactory.getReflectionFactory().newConstructorAccessor(enumClass.getDeclaredConstructor(parameterTypes));
    }

    public static void setFailsafeFieldValue(Field field, Object target, Object value) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        int modifiers = modifiersField.getInt(field);
        modifiersField.setInt(field, modifiers &= 0xFFFFFFEF);
        FieldAccessor fa = ReflectionFactory.getReflectionFactory().newFieldAccessor(field, false);
        fa.set(target, value);
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            AccessibleObject.setAccessible(new Field[]{field}, true);
            ReflectionUtils.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws NoSuchFieldException, IllegalAccessException {
        ReflectionUtils.blankField(enumClass, "enumConstantDirectory");
        ReflectionUtils.blankField(enumClass, "enumConstants");
    }

    public static enum PackageType {
        MINECRAFT_SERVER("net.minecraft.server." + PackageType.getServerVersion()),
        CRAFTBUKKIT("org.bukkit.craftbukkit." + PackageType.getServerVersion()),
        CRAFTBUKKIT_BLOCK(CRAFTBUKKIT, "block"),
        CRAFTBUKKIT_CHUNKIO(CRAFTBUKKIT, "chunkio"),
        CRAFTBUKKIT_COMMAND(CRAFTBUKKIT, "command"),
        CRAFTBUKKIT_CONVERSATIONS(CRAFTBUKKIT, "conversations"),
        CRAFTBUKKIT_ENCHANTMENS(CRAFTBUKKIT, "enchantments"),
        CRAFTBUKKIT_ENTITY(CRAFTBUKKIT, "entity"),
        CRAFTBUKKIT_EVENT(CRAFTBUKKIT, "event"),
        CRAFTBUKKIT_GENERATOR(CRAFTBUKKIT, "generator"),
        CRAFTBUKKIT_HELP(CRAFTBUKKIT, "help"),
        CRAFTBUKKIT_INVENTORY(CRAFTBUKKIT, "inventory"),
        CRAFTBUKKIT_MAP(CRAFTBUKKIT, "map"),
        CRAFTBUKKIT_METADATA(CRAFTBUKKIT, "metadata"),
        CRAFTBUKKIT_POTION(CRAFTBUKKIT, "potion"),
        CRAFTBUKKIT_PROJECTILES(CRAFTBUKKIT, "projectiles"),
        CRAFTBUKKIT_SCHEDULER(CRAFTBUKKIT, "scheduler"),
        CRAFTBUKKIT_SCOREBOARD(CRAFTBUKKIT, "scoreboard"),
        CRAFTBUKKIT_UPDATER(CRAFTBUKKIT, "updater"),
        CRAFTBUKKIT_UTIL(CRAFTBUKKIT, "wetspongeutils");

        private final String path;

        private PackageType(PackageType parent, String path) {
            this((Object)((Object)parent) + "." + path);
        }

        private PackageType(String path) {
            this.path = path;
        }

        public static String getServerVersion() {
            try {
                return Class.forName("org.bukkit.Bukkit").getMethod("getServer", new Class[0]).invoke(null, new Object[0]).getClass().getPackage().getName().substring(23);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public Class<?> getClass(String className) throws ClassNotFoundException {
            return Class.forName((Object)((Object)this) + "." + className);
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            return this.path;
        }
    }

    public static enum DataType {
        BYTE(Byte.TYPE, Byte.class),
        SHORT(Short.TYPE, Short.class),
        INTEGER(Integer.TYPE, Integer.class),
        LONG(Long.TYPE, Long.class),
        CHARACTER(Character.TYPE, Character.class),
        FLOAT(Float.TYPE, Float.class),
        DOUBLE(Double.TYPE, Double.class),
        BOOLEAN(Boolean.TYPE, Boolean.class);

        private static final Map<Class<?>, DataType> CLASS_MAP;
        private final Class<?> primitive;
        private final Class<?> reference;

        private DataType(Class<?> primitive, Class<?> reference) {
            this.primitive = primitive;
            this.reference = reference;
        }

        public static boolean compare(Class<?>[] primary, Class<?>[] secondary) {
            if (primary == null || secondary == null || primary.length != secondary.length) {
                return true;
            }
            for (int index = 0; index < primary.length; ++index) {
                Class<?> primaryClass = primary[index];
                Class<?> secondaryClass = secondary[index];
                if (primaryClass.equals(secondaryClass) || primaryClass.isAssignableFrom(secondaryClass)) continue;
                return true;
            }
            return false;
        }

        public static DataType fromClass(Class<?> clazz) {
            return CLASS_MAP.get(clazz);
        }

        public static Class<?> getPrimitive(Class<?> clazz) {
            DataType type = DataType.fromClass(clazz);
            return type == null ? clazz : type.getPrimitive();
        }

        public static Class<?>[] getPrimitive(Class<?>[] classes) {
            int length = classes == null ? 0 : classes.length;
            Class[] types = new Class[length];
            for (int index = 0; index < length; ++index) {
                types[index] = DataType.getPrimitive(classes[index]);
            }
            return types;
        }

        public static Class<?>[] getPrimitive(Object[] objects) {
            int length = objects == null ? 0 : objects.length;
            Class[] types = new Class[length];
            for (int index = 0; index < length; ++index) {
                types[index] = DataType.getPrimitive(objects[index].getClass());
            }
            return types;
        }

        public static Class<?> getReference(Class<?> clazz) {
            DataType type = DataType.fromClass(clazz);
            return type == null ? clazz : type.getReference();
        }

        public static Class<?>[] getReference(Class<?>[] classes) {
            int length = classes == null ? 0 : classes.length;
            Class[] types = new Class[length];
            for (int index = 0; index < length; ++index) {
                types[index] = DataType.getReference(classes[index]);
            }
            return types;
        }

        public static Class<?>[] getReference(Object[] objects) {
            int length = objects == null ? 0 : objects.length;
            Class[] types = new Class[length];
            for (int index = 0; index < length; ++index) {
                types[index] = DataType.getReference(objects[index].getClass());
            }
            return types;
        }

        public Class<?> getPrimitive() {
            return this.primitive;
        }

        public Class<?> getReference() {
            return this.reference;
        }

        static {
            CLASS_MAP = new HashMap();
            for (DataType type : DataType.values()) {
                CLASS_MAP.put(type.primitive, type);
                CLASS_MAP.put(type.reference, type);
            }
        }
    }
}

