/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.user;

import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.parser.player.PlayerParser;
import com.degoos.wetsponge.user.WSUser;
import com.degoos.wetsponge.util.Validate;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.manipulator.mutable.entity.JoinData;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.service.whitelist.WhitelistService;

public class SpongeUser
implements WSUser {
    private User user;

    public static SpongeUser of(UUID uuid) {
        return new SpongeUser(((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).getOrCreate(GameProfile.of((UUID)uuid, null)));
    }

    public static SpongeUser of(UUID uuid, String name) {
        return new SpongeUser(((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).getOrCreate(GameProfile.of((UUID)uuid, (String)name)));
    }

    public SpongeUser(User user) {
        Validate.notNull(user, "User cannot be null!");
        this.user = user;
    }

    @Override
    public boolean isOnline() {
        return this.user.isOnline();
    }

    @Override
    public String getName() {
        return this.user.getName();
    }

    @Override
    public UUID getUniqueId() {
        return this.user.getUniqueId();
    }

    @Override
    public boolean isBanned() {
        return ((BanService)Sponge.getGame().getServiceManager().provideUnchecked(BanService.class)).isBanned(this.user.getProfile());
    }

    @Override
    public boolean isWhitelisted() {
        return ((WhitelistService)Sponge.getGame().getServiceManager().provideUnchecked(WhitelistService.class)).isWhitelisted(this.user.getProfile());
    }

    @Override
    public void setWhitelisted(boolean whitelisted) {
        if (whitelisted) {
            ((WhitelistService)Sponge.getGame().getServiceManager().provideUnchecked(WhitelistService.class)).addProfile(this.user.getProfile());
        } else {
            ((WhitelistService)Sponge.getGame().getServiceManager().provideUnchecked(WhitelistService.class)).removeProfile(this.user.getProfile());
        }
    }

    @Override
    public Optional<WSPlayer> getPlayer() {
        return this.user.getPlayer().map(player -> PlayerParser.getOrCreatePlayer(player, player.getUniqueId()));
    }

    @Override
    public long getFirstPlayed() {
        Optional optional = this.user.get(JoinData.class);
        return optional.map(joinData -> ((Instant)joinData.firstPlayed().get()).toEpochMilli()).orElse(0L);
    }

    @Override
    public long getLastPlayed() {
        Optional optional = this.user.get(JoinData.class);
        return optional.map(joinData -> ((Instant)joinData.lastPlayed().get()).toEpochMilli()).orElse(0L);
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.user.get(JoinData.class).isPresent();
    }

    public User getHandled() {
        return this.user;
    }
}

