/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.user;

import com.degoos.wetsponge.user.SpongeProfileProperty;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.user.WSProfileProperty;
import com.degoos.wetsponge.util.Validate;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.property.ProfileProperty;

public class SpongeGameProfile
implements WSGameProfile {
    private GameProfile gameProfile;

    public static WSGameProfile of(UUID uniqueId, @Nullable String name) {
        return new SpongeGameProfile(Sponge.getServer().getGameProfileManager().createProfile(uniqueId, name));
    }

    public SpongeGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    @Override
    public UUID getId() {
        return this.gameProfile.getUniqueId();
    }

    @Override
    public Optional<String> getName() {
        return this.gameProfile.getName();
    }

    @Override
    public Multimap<String, WSProfileProperty> getPropertyMap() {
        LinkedHashMultimap<String, WSProfileProperty> map = LinkedHashMultimap.create();
        this.gameProfile.getPropertyMap().asMap().forEach((name, collection) -> collection.forEach(prop -> map.put((String)name, new SpongeProfileProperty((ProfileProperty)prop))));
        return map;
    }

    @Override
    public WSGameProfile addProperty(String name, WSProfileProperty property) {
        Validate.notNull(name, "Name cannot be null!");
        Validate.notNull(property, "Property cannot be null!");
        this.gameProfile.addProperty(name, ((SpongeProfileProperty)property).getHandled());
        return this;
    }

    @Override
    public boolean isFilled() {
        return this.gameProfile.isFilled();
    }

    public GameProfile getHandled() {
        return this.gameProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeGameProfile that = (SpongeGameProfile)o;
        return this.gameProfile.equals(that.gameProfile);
    }

    public int hashCode() {
        return this.gameProfile.hashCode();
    }
}

