/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.user;

import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.parser.player.PlayerParser;
import com.degoos.wetsponge.user.WSUser;
import com.degoos.wetsponge.util.Validate;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class SpigotUser
implements WSUser {
    private OfflinePlayer offlinePlayer;

    public static SpigotUser of(UUID uuid) {
        return new SpigotUser(Bukkit.getOfflinePlayer((UUID)uuid));
    }

    public SpigotUser(OfflinePlayer offlinePlayer) {
        Validate.notNull(offlinePlayer, "Offline player cannot be null!");
        this.offlinePlayer = offlinePlayer;
    }

    @Override
    public boolean isOnline() {
        return this.offlinePlayer.isOnline();
    }

    @Override
    public String getName() {
        return this.offlinePlayer.getName();
    }

    @Override
    public UUID getUniqueId() {
        return this.offlinePlayer.getUniqueId();
    }

    @Override
    public boolean isBanned() {
        return this.offlinePlayer.isBanned();
    }

    @Override
    public boolean isWhitelisted() {
        return this.offlinePlayer.isWhitelisted();
    }

    @Override
    public void setWhitelisted(boolean whitelisted) {
        this.offlinePlayer.setWhitelisted(whitelisted);
    }

    @Override
    public Optional<WSPlayer> getPlayer() {
        return Optional.ofNullable(this.offlinePlayer.getPlayer()).map(player -> PlayerParser.getOrCreatePlayer(player, player.getUniqueId()));
    }

    @Override
    public long getFirstPlayed() {
        return this.offlinePlayer.getFirstPlayed();
    }

    @Override
    public long getLastPlayed() {
        return this.offlinePlayer.getLastPlayed();
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.offlinePlayer.hasPlayedBefore();
    }

    public OfflinePlayer getHandled() {
        return this.offlinePlayer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpigotUser that = (SpigotUser)o;
        return this.offlinePlayer.equals(that.offlinePlayer);
    }

    public int hashCode() {
        return this.offlinePlayer.hashCode();
    }
}

