/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.timing;

import co.aikar.wetspongeutils.JSONUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WSTiming {
    private WSTiming parent;
    private long timesExecuted;
    private long startTime;
    private long stopTime;
    private long maximumDelay;
    private long totalDelay;
    private List<WSTiming> subTimings;
    private String name;
    private long firstExecution;
    private long lastExecution;
    private StackTraceElement caller;

    public WSTiming(WSTiming parent, String name, StackTraceElement caller) {
        this.parent = parent;
        this.name = name;
        this.totalDelay = 0L;
        this.maximumDelay = 0L;
        this.stopTime = 0L;
        this.startTime = 0L;
        this.subTimings = new LinkedList<WSTiming>();
        this.caller = caller;
    }

    public void start() {
        this.startTime = System.nanoTime();
    }

    public void stop() {
        this.stopTime = System.nanoTime();
        long delay = this.stopTime - this.startTime;
        this.maximumDelay = Math.max(delay, this.maximumDelay);
        this.totalDelay += delay;
        this.lastExecution = System.currentTimeMillis();
        if (this.timesExecuted == 0L) {
            this.firstExecution = this.lastExecution;
        }
        ++this.timesExecuted;
    }

    public String getName() {
        return this.name;
    }

    public long getTimesExecuted() {
        return this.timesExecuted;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public long getMaximumDelay() {
        return this.maximumDelay;
    }

    public long getTotalDelay() {
        return this.totalDelay;
    }

    public double getMillisMaximumDelay() {
        return (double)this.maximumDelay / 1000000.0;
    }

    public double getMillisTotalDelay() {
        return (double)this.totalDelay / 1000000.0;
    }

    public WSTiming getParent() {
        return this.parent;
    }

    public List<WSTiming> getSubTimings() {
        return this.subTimings;
    }

    public Map export() {
        Map map = JSONUtil.createObject(JSONUtil.pair("times", (Object)this.timesExecuted), JSONUtil.pair("maximum_delay", (Object)this.maximumDelay), JSONUtil.pair("total_delay", (Object)this.totalDelay), JSONUtil.pair("name", (Object)this.name), JSONUtil.pair("first_execution", (Object)this.firstExecution), JSONUtil.pair("last_execution", (Object)this.lastExecution));
        if (!this.subTimings.isEmpty()) {
            map.put("timings", JSONUtil.toArrayMapper(this.subTimings, WSTiming::export));
        }
        map.put("type", "simple");
        map.put("asynchronous", false);
        map.put("task_type", "instantaneous");
        map.put("delay", -1);
        map.put("interval", -1);
        map.put("times_to_execute", -1);
        map.put("caller", this.caller.toString());
        return map;
    }

    public void merge(WSTiming timing) {
        this.timesExecuted += timing.timesExecuted;
        this.maximumDelay = Math.max(this.maximumDelay, timing.maximumDelay);
        this.totalDelay += timing.totalDelay;
        timing.subTimings.forEach(toMerge -> {
            WSTiming subTiming = this.subTimings.stream().filter(target -> target.getName().equals(toMerge.getName())).findAny().orElse(null);
            if (subTiming == null) {
                this.subTimings.add((WSTiming)toMerge);
            } else {
                subTiming.merge((WSTiming)toMerge);
            }
        });
    }
}

