/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.text;

import com.degoos.wetsponge.enums.EnumTextColor;
import com.degoos.wetsponge.enums.EnumTextStyle;
import com.degoos.wetsponge.resource.centeredmessages.CenteredMessageSender;
import com.degoos.wetsponge.text.SpongeTranslatableText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.text.action.click.SpongeClickAction;
import com.degoos.wetsponge.text.action.click.WSClickAction;
import com.degoos.wetsponge.text.action.hover.SpongeHoverAction;
import com.degoos.wetsponge.text.action.hover.WSHoverAction;
import com.degoos.wetsponge.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TranslatableText;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.serializer.TextSerializers;

public class SpongeText
implements WSText {
    private Text text;

    public static SpongeText of(Text text) {
        if (text instanceof TranslatableText) {
            return new SpongeTranslatableText((TranslatableText)text);
        }
        return new SpongeText(text);
    }

    protected SpongeText(Text text) {
        this.text = text;
    }

    public SpongeText(String string) {
        this.text = Text.of((String)string);
    }

    public static SpongeText getByFormattingText(String text) {
        return new SpongeText(TextSerializers.LEGACY_FORMATTING_CODE.deserialize(text));
    }

    @Override
    public String getText() {
        return this.text.toPlainSingle();
    }

    @Override
    public Optional<EnumTextColor> getColor() {
        return EnumTextColor.getByName(this.text.getColor().getId());
    }

    @Override
    public Collection<EnumTextStyle> getStyles() {
        ArrayList<EnumTextStyle> styles = new ArrayList<EnumTextStyle>();
        TextStyle style = this.text.getStyle();
        if (style.isBold().orElse(false).booleanValue()) {
            styles.add(EnumTextStyle.BOLD);
        }
        if (style.isItalic().orElse(false).booleanValue()) {
            styles.add(EnumTextStyle.ITALIC);
        }
        if (style.isObfuscated().orElse(false).booleanValue()) {
            styles.add(EnumTextStyle.OBFUSCATED);
        }
        if (style.hasStrikethrough().orElse(false).booleanValue()) {
            styles.add(EnumTextStyle.STRIKETHROUGH);
        }
        if (style.hasUnderline().orElse(false).booleanValue()) {
            styles.add(EnumTextStyle.UNDERLINE);
        }
        return styles;
    }

    @Override
    public Collection<? extends WSText> getChildren() {
        return this.text.getChildren().stream().map(SpongeText::of).collect(Collectors.toList());
    }

    @Override
    public Optional<WSClickAction> getClickAction() {
        return this.getHandled().getClickAction().map(SpongeClickAction::of);
    }

    @Override
    public Optional<WSHoverAction> getHoverAction() {
        return this.getHandled().getHoverAction().map(SpongeHoverAction::of);
    }

    @Override
    public boolean contains(String sequence) {
        if (this.text.toPlainSingle().contains(sequence)) {
            return true;
        }
        for (WSText wSText : this.getChildren()) {
            if (!wSText.contains(sequence)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<WSText> split(String regex) {
        ArrayList<WSText> list = new ArrayList<WSText>();
        boolean endsWithRegex = false;
        WSText clone = this.moveChildrenToOneList();
        WSText parent = clone.cloneSingle();
        if (parent.getText().contains(regex)) {
            endsWithRegex = parent.getText().endsWith(regex);
            String[] strings = parent.getText().split(regex);
            parent = clone.cloneSingle(strings.length > 0 ? strings[0] : "");
            if (strings.length > 1) {
                for (int i = 1; i < strings.length; ++i) {
                    list.add(parent);
                    parent = clone.cloneSingle(strings[i]);
                }
            }
        }
        if (endsWithRegex) {
            list.add(parent);
        }
        WSText.Builder lastBuilder = endsWithRegex ? null : parent.toBuilder();
        Collection<? extends WSText> children = clone.getChildren();
        for (WSText wSText : children) {
            if (wSText.getText().contains(regex)) {
                String[] strings = wSText.getText().split(regex);
                if (strings.length <= 1) {
                    WSText.Builder childBuilder = this.applyParent(wSText, parent, strings.length == 0 ? "" : strings[0]);
                    if (endsWithRegex) {
                        lastBuilder = childBuilder;
                    } else {
                        lastBuilder.append(childBuilder.build());
                    }
                    if (!(endsWithRegex = wSText.getText().endsWith(regex))) continue;
                    list.add(lastBuilder.build());
                    continue;
                }
                if (endsWithRegex) {
                    lastBuilder = wSText.cloneSingle(strings[0]).toBuilder();
                } else {
                    lastBuilder.append(wSText.cloneSingle(strings[0]));
                }
                endsWithRegex = wSText.getText().endsWith(regex);
                for (int i = 1; i < strings.length; ++i) {
                    list.add(lastBuilder.build());
                    WSText.Builder childBuilder = this.applyParent(wSText, parent, strings[1]);
                    if (!wSText.getColor().isPresent() && parent.getColor().isPresent()) {
                        childBuilder.color(parent.getColor().get());
                    }
                    Collection<EnumTextStyle> styles = wSText.getStyles();
                    styles.addAll(parent.getStyles());
                    childBuilder.style(styles);
                    if (!wSText.getHoverAction().isPresent() && parent.getHoverAction().isPresent()) {
                        childBuilder.hoverAction(parent.getHoverAction().get());
                    }
                    if (!wSText.getClickAction().isPresent() && parent.getClickAction().isPresent()) {
                        childBuilder.clickAction(parent.getClickAction().get());
                    }
                    lastBuilder = childBuilder;
                }
                if (!endsWithRegex) continue;
                list.add(lastBuilder.build());
                continue;
            }
            WSText.Builder childBuilder = this.applyParent(wSText, parent, wSText.getText());
            if (endsWithRegex) {
                lastBuilder = childBuilder;
            } else {
                lastBuilder.append(childBuilder.build());
            }
            endsWithRegex = false;
        }
        if (!endsWithRegex) {
            list.add(lastBuilder.build());
        }
        return list;
    }

    private WSText.Builder applyParent(WSText child, WSText parent, String name) {
        WSText.Builder childBuilder = child.cloneSingle(name).toBuilder();
        if (!child.getColor().isPresent() && parent.getColor().isPresent()) {
            childBuilder.color(parent.getColor().get());
        }
        Collection<EnumTextStyle> styles = child.getStyles();
        styles.addAll(parent.getStyles());
        childBuilder.style(styles);
        if (!child.getHoverAction().isPresent() && parent.getHoverAction().isPresent()) {
            childBuilder.hoverAction(parent.getHoverAction().get());
        }
        if (!child.getClickAction().isPresent() && parent.getClickAction().isPresent()) {
            childBuilder.clickAction(parent.getClickAction().get());
        }
        return childBuilder;
    }

    @Override
    public WSText moveChildrenToOneList() {
        WSText.Builder builder = this.cloneSingle().toBuilder();
        this.getChildren().forEach(child -> {
            builder.append(child.cloneSingle());
            child.getChildren().forEach(childChild -> this.append(builder, (WSText)childChild, (WSText)child));
        });
        return builder.build();
    }

    private void append(WSText.Builder builder, WSText child, WSText parent) {
        WSText.Builder childBuilder = child.cloneSingle().toBuilder();
        if (!child.getColor().isPresent() && parent.getColor().isPresent()) {
            childBuilder.color(parent.getColor().get());
        }
        Collection<EnumTextStyle> styles = child.getStyles();
        styles.addAll(parent.getStyles());
        childBuilder.style(styles);
        if (!child.getHoverAction().isPresent() && parent.getHoverAction().isPresent()) {
            childBuilder.hoverAction(parent.getHoverAction().get());
        }
        if (!child.getClickAction().isPresent() && parent.getClickAction().isPresent()) {
            childBuilder.clickAction(parent.getClickAction().get());
        }
        WSText newChild = childBuilder.build();
        builder.append(newChild);
        child.getChildren().forEach(childChild -> this.append(builder, (WSText)childChild, newChild));
    }

    @Override
    public WSText replace(String toReplace, String replacement) {
        WSText.Builder clone = this.cloneSingle(this.getText().replace(toReplace, replacement)).toBuilder();
        this.getChildren().forEach(child -> clone.append(child.replace(toReplace, replacement)));
        return clone.build();
    }

    @Override
    public WSText replace(String toReplace, WSText replacement) {
        if (!this.contains(toReplace)) {
            return this;
        }
        boolean endsWithToReplace = this.toPlain().endsWith(toReplace);
        List<WSText> split = this.split(toReplace);
        WSText.Builder firstBuilder = split.get(0).toBuilder();
        firstBuilder.append(replacement);
        for (int i = 1; i < split.size() - (endsWithToReplace ? 0 : 1); ++i) {
            WSText text = split.get(i);
            WSText.Builder builder = text.toBuilder();
            builder.append(this.applyParent(replacement, text, replacement.getText()).build());
            firstBuilder.append(builder.build());
        }
        return firstBuilder.build();
    }

    @Override
    public String toFormattingText() {
        return TextSerializers.LEGACY_FORMATTING_CODE.serialize(this.text);
    }

    @Override
    public String toPlain() {
        return this.text.toPlain();
    }

    @Override
    public WSText clone() {
        return this.clone(this.getText());
    }

    @Override
    public WSText clone(String string) {
        WSText.Builder text = WSText.builder(string);
        this.getColor().ifPresent(text::color);
        text.style(this.getStyles());
        this.getHoverAction().ifPresent(text::hoverAction);
        this.getClickAction().ifPresent(text::clickAction);
        this.getChildren().forEach(child -> text.append(child.clone()));
        return text.build();
    }

    @Override
    public WSText cloneSingle() {
        return this.cloneSingle(this.getText());
    }

    @Override
    public WSText cloneSingle(String string) {
        WSText.Builder text = WSText.builder(string);
        this.getColor().ifPresent(text::color);
        text.style(this.getStyles());
        this.getHoverAction().ifPresent(text::hoverAction);
        this.getClickAction().ifPresent(text::clickAction);
        return text.build();
    }

    public Text getHandled() {
        return this.text;
    }

    public String toString() {
        return this.text.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeText that = (SpongeText)o;
        return that.toFormattingText().equals(this.toFormattingText());
    }

    public int hashCode() {
        return this.toFormattingText().hashCode();
    }

    public static class Builder
    implements WSText.Builder {
        private Text.Builder builder;

        public Builder() {
            this.builder = Text.builder();
        }

        public Builder(String string) {
            this.builder = Text.builder((String)string);
        }

        public Builder(WSText text) {
            this.builder = ((SpongeText)text).getHandled().toBuilder();
        }

        @Override
        public WSText build() {
            return SpongeText.of(this.builder.build());
        }

        @Override
        public WSText.Builder color(EnumTextColor color) {
            this.builder.color(Sponge.getRegistry().getType(TextColor.class, color.name()).orElse(TextColors.WHITE));
            return this;
        }

        @Override
        public WSText.Builder style(EnumTextStyle style) {
            return this.style(Collections.singleton(style));
        }

        @Override
        public WSText.Builder style(Collection<EnumTextStyle> styles) {
            TextStyle style = new TextStyle(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
            for (EnumTextStyle textStyle : styles) {
                switch (textStyle) {
                    case OBFUSCATED: {
                        style = style.obfuscated(Boolean.valueOf(true));
                        break;
                    }
                    case BOLD: {
                        style = style.bold(Boolean.valueOf(true));
                        break;
                    }
                    case STRIKETHROUGH: {
                        style = style.strikethrough(Boolean.valueOf(true));
                        break;
                    }
                    case UNDERLINE: {
                        style = style.underline(Boolean.valueOf(true));
                        break;
                    }
                    case ITALIC: {
                        style = style.italic(Boolean.valueOf(true));
                        break;
                    }
                    case RESET: {
                        style = new TextStyle(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
                    }
                }
            }
            this.builder.style(new TextStyle[]{style});
            return this;
        }

        @Override
        public WSText.Builder clickAction(WSClickAction action) {
            if (action == null) {
                this.builder.onClick(null);
            } else {
                this.builder.onClick(((SpongeClickAction)action).getHandled());
            }
            return this;
        }

        @Override
        public WSText.Builder hoverAction(WSHoverAction action) {
            if (action == null) {
                this.builder.onHover(null);
            } else {
                this.builder.onHover(((SpongeHoverAction)action).getHandled());
            }
            return this;
        }

        @Override
        public WSText.Builder append(WSText ... children) {
            Text[] texts = new Text[children.length];
            for (int i = 0; i < children.length; ++i) {
                texts[i] = ((SpongeText)children[i]).getHandled();
            }
            this.builder.append(texts);
            return this;
        }

        @Override
        public WSText.Builder append(Collection<? extends WSText> children) {
            this.builder.append((Collection)children.stream().map(text -> ((SpongeText)text).getHandled()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public WSText.Builder newLine() {
            this.builder.append(new Text[]{Text.NEW_LINE});
            return this;
        }

        @Override
        public WSText.Builder center() {
            this.builder = TextSerializers.LEGACY_FORMATTING_CODE.deserialize(CenteredMessageSender.getCenteredMessage(TextSerializers.LEGACY_FORMATTING_CODE.serialize(this.builder.build()))).toBuilder();
            return this;
        }

        @Override
        public WSText.Builder stripColors() {
            this.builder = TextSerializers.LEGACY_FORMATTING_CODE.deserialize(StringUtils.stripColors(TextSerializers.LEGACY_FORMATTING_CODE.serialize(this.builder.build()))).toBuilder();
            return this;
        }

        @Override
        public WSText.Builder translateColors() {
            this.builder = TextSerializers.LEGACY_FORMATTING_CODE.deserialize(TextSerializers.LEGACY_FORMATTING_CODE.serialize(this.builder.build()).replace('&', '\u00a7')).toBuilder();
            return this;
        }
    }
}

