/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.task;

import com.degoos.wetsponge.SpongeWetSponge;
import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumTextColor;
import com.degoos.wetsponge.plugin.WSPlugin;
import com.degoos.wetsponge.task.WSTask;
import com.degoos.wetsponge.task.WSTaskPool;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import java.util.UUID;
import java.util.function.Consumer;
import org.spongepowered.api.scheduler.Task;

public class SpongeTask
implements WSTask {
    private Consumer<WSTask> consumer;
    private Task task;
    private long times = -1L;
    private long timesExecuted;
    private WSPlugin plugin;
    private StackTraceElement caller;
    private String taskDescription;
    private boolean timer;
    private boolean instantaneous;
    private boolean later;
    private long delay;
    private long interval;

    public SpongeTask(Runnable runnable) {
        this.timesExecuted = 0L;
        this.caller = Thread.currentThread().getStackTrace()[3];
        this.consumer = wsTask -> {
            try {
                if (this.times > -1L && this.times <= this.timesExecuted) {
                    this.cancel();
                    return;
                }
                WSPlugin caller = WetSponge.getTimings().getAssignedPlugin();
                WetSponge.getTimings().assignPluginToThread(this.plugin);
                WetSponge.getTimings().startTiming(this.taskDescription + " (From " + this.caller + ")");
                runnable.run();
                WetSponge.getTimings().stopTiming();
                WetSponge.getTimings().assignPluginToThread(caller);
                ++this.timesExecuted;
            }
            catch (Throwable ex) {
                InternalLogger.printException(ex, WSText.builder("An error has occurred while WetSponge was executing the task ").append(WSText.of(this.task.getUniqueId().toString(), EnumTextColor.YELLOW)).append(WSText.of("!")).build());
            }
        };
    }

    public SpongeTask(Consumer<WSTask> consumer) {
        this.caller = Thread.currentThread().getStackTrace()[3];
        this.consumer = wsTask -> {
            try {
                if (this.times > -1L && this.times <= this.timesExecuted) {
                    this.cancel();
                    return;
                }
                WSPlugin caller = WetSponge.getTimings().getAssignedPlugin();
                WetSponge.getTimings().assignPluginToThread(this.plugin);
                WetSponge.getTimings().startTiming(this.taskDescription + " (UUID: " + this.getUniqueId() + ") (From " + this.caller + ")");
                consumer.accept(this);
                WetSponge.getTimings().stopTiming();
                WetSponge.getTimings().assignPluginToThread(caller);
                ++this.timesExecuted;
            }
            catch (Throwable ex) {
                InternalLogger.printException(ex, WSText.builder("An error has occurred while WetSponge was executing the task ").append(WSText.of(this.task.getUniqueId().toString(), EnumTextColor.YELLOW)).append(WSText.of("!")).build());
            }
        };
    }

    @Override
    public void run(WSPlugin plugin) {
        this.plugin = plugin;
        this.instantaneous = true;
        this.later = false;
        this.timer = false;
        this.taskDescription = plugin.getId() + " task. (Run)";
        this.task = Task.builder().execute(task1 -> this.consumer.accept(this)).submit((Object)SpongeWetSponge.getInstance());
    }

    @Override
    public void runAsynchronously(WSPlugin plugin) {
        this.plugin = plugin;
        this.instantaneous = true;
        this.later = false;
        this.timer = false;
        this.taskDescription = plugin.getId() + " task. (Run) (Async)";
        this.task = Task.builder().async().execute(task1 -> this.consumer.accept(this)).submit((Object)SpongeWetSponge.getInstance());
    }

    @Override
    public void runTaskLater(long delay, WSPlugin plugin) {
        if (!WSTaskPool.addTask(plugin, this)) {
            return;
        }
        this.plugin = plugin;
        this.instantaneous = false;
        this.later = true;
        this.timer = false;
        this.delay = delay;
        this.taskDescription = plugin.getId() + " task. (Later: " + delay + ")";
        this.task = Task.builder().delayTicks(delay).execute(task1 -> this.consumer.accept(this)).submit((Object)SpongeWetSponge.getInstance());
    }

    @Override
    public void runTaskLaterAsynchronously(long delay, WSPlugin plugin) {
        if (!WSTaskPool.addTask(plugin, this)) {
            return;
        }
        this.plugin = plugin;
        this.instantaneous = false;
        this.later = true;
        this.timer = false;
        this.delay = delay;
        this.taskDescription = plugin.getId() + " task. (Later: " + delay + ") (Async)";
        this.task = Task.builder().delayTicks(delay).async().execute(task1 -> this.consumer.accept(this)).submit((Object)SpongeWetSponge.getInstance());
    }

    @Override
    public void runTaskTimer(long delay, long interval, WSPlugin plugin) {
        if (!WSTaskPool.addTask(plugin, this)) {
            return;
        }
        this.plugin = plugin;
        this.instantaneous = false;
        this.later = false;
        this.timer = true;
        this.delay = delay;
        this.interval = interval;
        this.taskDescription = plugin.getId() + " task. (Timer: " + delay + ", " + interval + ")";
        this.task = Task.builder().delayTicks(delay).intervalTicks(interval).execute(task1 -> this.consumer.accept(this)).submit((Object)SpongeWetSponge.getInstance());
    }

    @Override
    public void runTaskTimer(long delay, long interval, long times, WSPlugin plugin) {
        this.times = times;
        this.instantaneous = false;
        this.later = false;
        this.timer = true;
        this.delay = delay;
        this.interval = interval;
        this.taskDescription = plugin.getId() + " task. (Timer: " + delay + ", " + interval + ", " + times + ")";
        this.runTaskTimer(delay, interval, plugin);
    }

    @Override
    public void runTaskTimerAsynchronously(long delay, long interval, WSPlugin plugin) {
        if (!WSTaskPool.addTask(plugin, this)) {
            return;
        }
        this.plugin = plugin;
        this.instantaneous = false;
        this.later = false;
        this.timer = true;
        this.delay = delay;
        this.interval = interval;
        this.taskDescription = plugin.getId() + " task. (Timer: " + delay + ", " + interval + ") (Async)";
        this.task = Task.builder().delayTicks(delay).intervalTicks(interval).async().execute(task1 -> this.consumer.accept(this)).submit((Object)SpongeWetSponge.getInstance());
    }

    @Override
    public void runTaskTimerAsynchronously(long delay, long interval, long times, WSPlugin plugin) {
        this.times = times;
        this.instantaneous = false;
        this.later = false;
        this.timer = true;
        this.delay = delay;
        this.interval = interval;
        this.taskDescription = plugin.getId() + " task. (Timer: " + delay + ", " + interval + ", " + times + ") (Async)";
        this.runTaskTimerAsynchronously(delay, interval, plugin);
    }

    @Override
    public UUID getUniqueId() {
        return this.task == null ? null : this.task.getUniqueId();
    }

    @Override
    public StackTraceElement getCallerStackTraceElement() {
        return this.caller;
    }

    @Override
    public long getTimesExecuted() {
        return this.timesExecuted;
    }

    @Override
    public boolean isAsynchronous() {
        return this.task != null && this.task.isAsynchronous();
    }

    @Override
    public boolean isTimer() {
        return this.timer;
    }

    @Override
    public boolean isInstantaneous() {
        return this.instantaneous;
    }

    @Override
    public boolean isLater() {
        return this.later;
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public long getTimesToExecute() {
        return this.times;
    }

    @Override
    public WSPlugin getPlugin() {
        return this.plugin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeTask that = (SpongeTask)o;
        return this.task != null ? this.task.equals(that.task) : that.task == null;
    }

    public int hashCode() {
        return this.task != null ? this.task.hashCode() : 0;
    }

    @Override
    public void cancel() {
        if (this.task != null) {
            this.task.cancel();
        }
    }
}

