/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.server;

import com.degoos.wetsponge.command.WSCommandSource;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumEnvironment;
import com.degoos.wetsponge.scoreboard.WSScoreboard;
import com.degoos.wetsponge.server.WSServerInfo;
import com.degoos.wetsponge.server.WSServerProperties;
import com.degoos.wetsponge.user.WSUser;
import com.degoos.wetsponge.world.WSWorld;
import com.degoos.wetsponge.world.WSWorldProperties;
import com.degoos.wetsponge.world.generation.populator.WSGenerationPopulator;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public interface WSServer {
    public Optional<WSWorld> getWorld(String var1);

    public Optional<WSWorld> getWorld(UUID var1);

    public Optional<WSWorld> loadWorld(String var1);

    public Optional<WSWorld> loadWorld(UUID var1);

    public boolean unloadWorld(WSWorld var1);

    public Set<WSWorld> getWorlds();

    public Optional<WSWorld> createWorld(WSWorldProperties var1, EnumEnvironment var2);

    public Optional<WSWorld> createWorld(WSWorldProperties var1, EnumEnvironment var2, WSGenerationPopulator var3);

    public boolean deleteWorld(WSWorld var1);

    public Optional<WSPlayer> getPlayer(String var1);

    public Optional<WSPlayer> getPlayer(UUID var1);

    public Set<WSPlayer> getOnlinePlayers();

    default public WSUser getUser(UUID uuid) {
        return WSUser.of(uuid);
    }

    default public WSUser getUser(UUID uuid, String name) {
        return WSUser.of(uuid, name);
    }

    public WSScoreboard getMainScoreboard();

    public WSScoreboard createScoreboard();

    public WSCommandSource getConsole();

    public WSServerInfo getServerInfo();

    public WSServerProperties getProperties();

    public void shutdown();
}

