/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.server;

import com.degoos.wetsponge.server.WSFavicon;
import com.degoos.wetsponge.util.InternalLogger;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;

public class SpigotFavicon
implements WSFavicon {
    private BufferedImage image;
    private String encoded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpigotFavicon(BufferedImage image) {
        this.image = image;
        try {
            Preconditions.checkArgument(image.getWidth() == 64, "favicon must be 64 pixels wide");
            Preconditions.checkArgument(image.getHeight() == 64, "favicon must be 64 pixels high");
            ByteBuf buf = Unpooled.buffer();
            try {
                ImageIO.write((RenderedImage)image, "PNG", (OutputStream)new ByteBufOutputStream(buf));
                ByteBuf base64 = Base64.encode((ByteBuf)buf);
                try {
                    this.encoded = "data:image/png;base64," + base64.toString(Charsets.UTF_8);
                }
                finally {
                    base64.release();
                }
            }
            finally {
                buf.release();
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An exception has occurred while WetSponge was trying to decode a server icon!");
            this.encoded = "data:image/png;base64,";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpigotFavicon(String encoded) {
        this.encoded = encoded;
        try {
            Preconditions.checkArgument(encoded.startsWith("data:image/png;base64,"), "Unknown favicon format");
            ByteBuf base64 = Unpooled.copiedBuffer((CharSequence)encoded.substring("data:image/png;base64,".length()), (Charset)Charsets.UTF_8);
            try {
                ByteBuf buf = Base64.decode((ByteBuf)base64);
                try {
                    BufferedImage result = ImageIO.read((InputStream)new ByteBufInputStream(buf));
                    Preconditions.checkState(result.getWidth() == 64, "favicon must be 64 pixels wide");
                    Preconditions.checkState(result.getHeight() == 64, "favicon must be 64 pixels high");
                    this.image = result;
                }
                finally {
                    buf.release();
                }
            }
            finally {
                base64.release();
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An exception has occurred while WetSponge was trying to decode a server icon!");
            this.image = new BufferedImage(64, 64, 1);
            Graphics graphics = this.image.getGraphics();
            graphics.drawString("Error", 20, 32);
        }
    }

    @Override
    public String toBase64() {
        return this.encoded;
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }
}

