/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.server;

import com.degoos.wetsponge.server.WSServerProperties;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import org.bukkit.Server;

public class Spigot13ServerProperties
implements WSServerProperties {
    private Object server;

    public Spigot13ServerProperties(Server server) {
        this.server = Spigot13HandledUtils.getServerHandle(server);
    }

    @Override
    public boolean isFlightAllowed() {
        return this.invokeMethod(this.server, "getAllowFlight", false, new Object[0]);
    }

    @Override
    public WSServerProperties setFlightAllowed(boolean flightAllowed) {
        this.invokeMethod(this.server, "setAllowFlight", null, flightAllowed);
        return this;
    }

    @Override
    public boolean isPVPEnabled() {
        return this.invokeMethod(this.server, "getPVP", false, new Object[0]);
    }

    @Override
    public WSServerProperties setPVPEnabled(boolean pvpEnabled) {
        this.invokeMethod(this.server, "setPVP", null, pvpEnabled);
        return this;
    }

    @Override
    public boolean canSpawnNPCs() {
        return this.invokeMethod(this.server, "getSpawnNPCs", false, new Object[0]);
    }

    @Override
    public WSServerProperties setCanSpawnNPCs(boolean canSpawnNPCs) {
        this.invokeMethod(this.server, "setSpawnNPCs", null, canSpawnNPCs);
        return this;
    }

    @Override
    public boolean canSpawnAnimals() {
        return this.invokeMethod(this.server, "getSpawnAnimals", false, new Object[0]);
    }

    @Override
    public WSServerProperties setCanSpawnAnimals(boolean canSpawnAnimals) {
        this.invokeMethod(this.server, "setSpawnAnimals", null, canSpawnAnimals);
        return this;
    }

    @Override
    public boolean preventProxyConnections() {
        return true;
    }

    @Override
    public WSServerProperties setPreventProxyConnections(boolean preventProxyConnections) {
        return this;
    }

    @Override
    public boolean isServerInOnlineMode() {
        return this.invokeMethod(this.server, "getOnlineMode", false, new Object[0]);
    }

    @Override
    public WSServerProperties setOnlineMode(boolean onlineMode) {
        this.invokeMethod(this.server, "setOnlineMode", null, onlineMode);
        return this;
    }

    @Override
    public WSText getMOTD() {
        String string = this.invokeMethod(this.server, "getMotd", "", new Object[0]);
        return string == null ? WSText.empty() : WSText.getByFormattingText(string);
    }

    @Override
    public WSServerProperties setMOTD(WSText motd) {
        this.invokeMethod(this.server, "setMotd", null, motd == null ? null : motd.toFormattingText());
        return this;
    }

    @Override
    public int getBuildLimit() {
        return this.invokeMethod(this.server, "getMaxBuildHeight", 255, new Object[0]);
    }

    @Override
    public WSServerProperties setBuildLimit(int buildLimit) {
        this.invokeMethod(this.server, "c", null, buildLimit);
        return this;
    }

    private <T> T invokeMethod(Object instance, String methodName, T defaultValue, Object ... arguments) {
        try {
            Object o = ReflectionUtils.invokeMethod(instance, methodName, arguments);
            if (o == null) {
                return defaultValue;
            }
            return (T)o;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was finding the property " + methodName + "! Returning default value " + defaultValue);
            return defaultValue;
        }
    }
}

