/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.server;

import com.degoos.wetsponge.resource.B64;
import com.degoos.wetsponge.server.Spigot13Favicon;
import com.degoos.wetsponge.server.WSFavicon;
import com.degoos.wetsponge.server.WSServerInfo;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.bukkit.Server;

public class Spigot13ServerInfo
implements WSServerInfo {
    private Server server;

    public Spigot13ServerInfo(Server server) {
        this.server = server;
    }

    @Override
    public int getOnlinePlayers() {
        return this.server.getOnlinePlayers().size();
    }

    @Override
    public int getMaxPlayers() {
        return this.server.getMaxPlayers();
    }

    @Override
    public int getIdleTimeout() {
        return this.server.getIdleTimeout();
    }

    @Override
    public void setIdleTimeout(int idleTimeout) {
        this.server.setIdleTimeout(idleTimeout);
    }

    @Override
    public boolean isOnlineMode() {
        return this.server.getOnlineMode();
    }

    @Override
    public boolean isFull() {
        return this.getMaxPlayers() <= this.getOnlinePlayers();
    }

    @Override
    public boolean hasWhiteList() {
        return this.server.hasWhitelist();
    }

    @Override
    public String getServerName() {
        return this.server.getName();
    }

    @Override
    public WSText getMotd() {
        return WSText.getByFormattingText(this.server.getMotd());
    }

    @Override
    public String getBase64ServerIcon() {
        String icon = "";
        File file = new File("server-icon.png");
        if (file.isFile()) {
            try {
                icon = "data:image/png;base64," + B64.encode(Files.toByteArray(file));
            }
            catch (IOException ex) {
                InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was trying to get the server icon!");
            }
        }
        return icon;
    }

    @Override
    public Optional<WSFavicon> getServerIcon() {
        try {
            File file = new File("server-icon.png");
            if (file.isFile()) {
                return Optional.of(new Spigot13Favicon(ImageIO.read(file)));
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was trying to get the server icon!");
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public Optional<InetSocketAddress> getBoundAddress() {
        return Optional.of(new InetSocketAddress(this.server.getIp(), this.server.getPort()));
    }
}

