/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.scoreboard;

import com.degoos.wetsponge.enums.EnumCriteria;
import com.degoos.wetsponge.enums.EnumDisplaySlot;
import com.degoos.wetsponge.scoreboard.WSObjective;
import com.degoos.wetsponge.scoreboard.WSTeam;
import com.degoos.wetsponge.text.WSText;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface WSScoreboard {
    public Optional<WSObjective> getObjective(String var1);

    public Optional<WSObjective> getObjective(EnumDisplaySlot var1);

    public WSObjective getOrCreateObjective(String var1, WSText var2, EnumCriteria var3);

    public void updateDisplaySlot(WSObjective var1, EnumDisplaySlot var2);

    default public void clearSlot(EnumDisplaySlot displaySlot) {
        this.updateDisplaySlot(null, displaySlot);
    }

    public Set<WSObjective> getObjectives();

    default public Set<WSObjective> getObjectivesByCriteria(EnumCriteria criteria) {
        return this.getObjectives().stream().filter(objective -> objective.getCriteria().equals((Object)criteria)).collect(Collectors.toSet());
    }

    public void removeObjective(WSObjective var1);

    public void clearObjectives();

    public Optional<WSTeam> getTeam(String var1);

    public boolean hasTeam(String var1);

    public WSTeam getOrCreateTeam(String var1);

    public Set<WSTeam> getTeams();

    public Optional<WSTeam> getMemberTeam(WSText var1);

    public boolean unregisterTeam(WSTeam var1);

    public void unregisterAllTeams();

    public Object getHandled();
}

