/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.scoreboard;

import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.Validate;

public abstract class WSObjectiveReplacement {
    private String key;

    public WSObjectiveReplacement(String key) {
        Validate.notNull(key, "Key cannot be null!");
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public abstract WSText getReplacement(WSPlayer var1);

    public WSText apply(WSText text, WSPlayer player) {
        WSText replacement = this.getReplacement(player);
        if (replacement == null) {
            return text;
        }
        return WSText.getByFormattingText(text.toFormattingText().replace(this.key, replacement.toFormattingText()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WSObjectiveReplacement that = (WSObjectiveReplacement)object;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

