/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.scoreboard;

import com.degoos.wetsponge.enums.EnumCollisionRule;
import com.degoos.wetsponge.enums.EnumVisibility;
import com.degoos.wetsponge.scoreboard.SpongeScoreboard;
import com.degoos.wetsponge.scoreboard.WSScoreboard;
import com.degoos.wetsponge.scoreboard.WSTeam;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.Validate;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scoreboard.CollisionRule;
import org.spongepowered.api.scoreboard.CollisionRules;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.Visibilities;
import org.spongepowered.api.scoreboard.Visibility;

public class SpongeTeam
implements WSTeam {
    private Team team;

    public SpongeTeam(Team team) {
        Validate.notNull(team, "Team cannot be null!");
        this.team = team;
    }

    @Override
    public String getName() {
        return this.team.getName();
    }

    @Override
    public WSText getDisplayName() {
        return SpongeText.of(this.team.getDisplayName());
    }

    @Override
    public void setDisplayName(@Nullable WSText name) {
        if (name == null) {
            this.team.setDisplayName(null);
        } else {
            this.team.setDisplayName(((SpongeText)name).getHandled());
        }
    }

    @Override
    public WSText getPrefix() {
        return SpongeText.of(this.team.getPrefix());
    }

    @Override
    public void setPrefix(@Nullable WSText prefix) {
        if (prefix == null) {
            this.team.setPrefix(null);
        } else {
            this.team.setPrefix(((SpongeText)prefix).getHandled());
        }
    }

    @Override
    public WSText getSuffix() {
        return SpongeText.of(this.team.getSuffix());
    }

    @Override
    public void setSuffix(@Nullable WSText suffix) {
        if (suffix == null) {
            this.team.setSuffix(null);
        } else {
            this.team.setSuffix(((SpongeText)suffix).getHandled());
        }
    }

    @Override
    public boolean allowFriendlyFire() {
        return this.team.allowFriendlyFire();
    }

    @Override
    public void setAllowFriendlyFire(boolean enabled) {
        this.team.setAllowFriendlyFire(enabled);
    }

    @Override
    public boolean canSeeFriendlyInvisibles() {
        return this.team.canSeeFriendlyInvisibles();
    }

    @Override
    public void setCanSeeFriendlyInvisibles(boolean enabled) {
        this.team.setCanSeeFriendlyInvisibles(enabled);
    }

    @Override
    public EnumVisibility getNameTagVisibility() {
        return EnumVisibility.getBySpongeName(this.team.getNameTagVisibility().getName()).orElse(EnumVisibility.ALWAYS);
    }

    @Override
    public void setNameTagVisibility(EnumVisibility visibility) {
        Validate.notNull((Object)visibility, "Visibility cannot be null!");
        this.team.setNameTagVisibility(Sponge.getRegistry().getType(Visibility.class, visibility.getSpongeName()).orElse(Visibilities.ALWAYS));
    }

    @Override
    public EnumVisibility getDeathMessageVisibility() {
        return EnumVisibility.getBySpongeName(this.team.getDeathMessageVisibility().getName()).orElse(EnumVisibility.ALWAYS);
    }

    @Override
    public void setDeathMessageVisibility(EnumVisibility visibility) {
        Validate.notNull((Object)visibility, "Visibility cannot be null!");
        this.team.setDeathMessageVisibility(Sponge.getRegistry().getType(Visibility.class, visibility.getSpongeName()).orElse(Visibilities.ALWAYS));
    }

    @Override
    public EnumCollisionRule getCollisionRule() {
        return EnumCollisionRule.getBySpongeName(this.team.getCollisionRule().getName()).orElse(EnumCollisionRule.ALWAYS);
    }

    @Override
    public void setCollisionRule(EnumCollisionRule collisionRule) {
        Validate.notNull((Object)collisionRule, "Collision rule cannot be null!");
        this.team.setCollisionRule(Sponge.getRegistry().getType(CollisionRule.class, collisionRule.getSpongeName()).orElse(CollisionRules.ALWAYS));
    }

    @Override
    public Set<WSText> getMembers() {
        return this.team.getMembers().stream().map(SpongeText::of).collect(Collectors.toSet());
    }

    @Override
    public void addMember(WSText member) {
        Validate.notNull(member, "Member cannot be null!");
        this.team.addMember(((SpongeText)member).getHandled());
    }

    @Override
    public boolean removeMember(WSText member) {
        Validate.notNull(member, "Member cannot be null!");
        return this.team.removeMember(((SpongeText)member).getHandled());
    }

    @Override
    public boolean hasMember(WSText member) {
        Validate.notNull(member, "Member cannot be null!");
        return this.getMembers().contains(member);
    }

    @Override
    public Optional<WSScoreboard> getScoreboard() {
        return this.team.getScoreboard().map(SpongeScoreboard::new);
    }

    @Override
    public boolean unregister() {
        return this.team.unregister();
    }

    public Team getHandled() {
        return this.team;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeTeam that = (SpongeTeam)o;
        return this.team.equals(that.team);
    }

    public int hashCode() {
        return this.team.hashCode();
    }
}

