/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.scoreboard;

import com.degoos.wetsponge.enums.EnumCriteria;
import com.degoos.wetsponge.scoreboard.SpongeScore;
import com.degoos.wetsponge.scoreboard.SpongeScoreboard;
import com.degoos.wetsponge.scoreboard.WSObjective;
import com.degoos.wetsponge.scoreboard.WSScore;
import com.degoos.wetsponge.scoreboard.WSScoreboard;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.objective.Objective;

public class SpongeObjective
implements WSObjective {
    private Objective objective;

    public SpongeObjective(Objective objective) {
        Validate.notNull(objective, "Objective cannot be null!");
        this.objective = objective;
    }

    @Override
    public String getName() {
        return this.objective.getName();
    }

    @Override
    public WSText getDisplayName() {
        return SpongeText.of(this.objective.getDisplayName());
    }

    @Override
    public void setDisplayName(WSText text) {
        this.objective.setDisplayName(((SpongeText)text).getHandled());
    }

    @Override
    public EnumCriteria getCriteria() {
        return EnumCriteria.getBySpongeName(this.objective.getCriterion().getName()).orElse(EnumCriteria.DUMMY);
    }

    @Override
    public Map<WSText, WSScore> getScores() {
        HashMap<WSText, WSScore> map = new HashMap<WSText, WSScore>();
        this.objective.getScores().forEach((spongeName, spongeScore) -> {
            SpongeText name = SpongeText.of(spongeName);
            map.put(name, new SpongeScore((Score)spongeScore));
        });
        return map;
    }

    @Override
    public boolean hasScore(WSText name) {
        return this.objective.hasScore(((SpongeText)name).getHandled());
    }

    @Override
    public WSScore getOrCreateScore(WSText name) {
        return new SpongeScore(this.objective.getOrCreateScore(((SpongeText)name).getHandled()));
    }

    @Override
    public boolean removeScore(WSText name) {
        return this.objective.removeScore(((SpongeText)name).getHandled());
    }

    @Override
    public boolean removeScore(WSScore score) {
        return this.objective.removeScore(((SpongeScore)score).getHandled());
    }

    @Override
    public void removeAllScoresWithScore(int score) {
        try {
            this.getScores().values().stream().filter(target -> target.getScore() == score).forEach(this::removeScore);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was removing all objectives with the score " + score + "!");
        }
    }

    @Override
    public Optional<WSScoreboard> getScoreboard() {
        return this.objective.getScoreboards().size() == 0 ? Optional.empty() : this.objective.getScoreboards().stream().findFirst().map(SpongeScoreboard::new);
    }

    public Objective getHandled() {
        return this.objective;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeObjective that = (SpongeObjective)o;
        return this.objective.equals(that.objective);
    }

    public int hashCode() {
        return this.objective.hashCode();
    }
}

