/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.scoreboard;

import com.degoos.wetsponge.enums.EnumCriteria;
import com.degoos.wetsponge.scoreboard.SpigotScore;
import com.degoos.wetsponge.scoreboard.SpigotScoreboard;
import com.degoos.wetsponge.scoreboard.WSObjective;
import com.degoos.wetsponge.scoreboard.WSScore;
import com.degoos.wetsponge.scoreboard.WSScoreboard;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.scoreboard.Objective;

public class SpigotObjective
implements WSObjective {
    private Objective objective;

    public SpigotObjective(Objective objective) {
        Validate.notNull(objective, "Objective cannot be null!");
        this.objective = objective;
    }

    @Override
    public String getName() {
        return this.objective.getName();
    }

    @Override
    public WSText getDisplayName() {
        return WSText.getByFormattingText(this.objective.getDisplayName());
    }

    @Override
    public void setDisplayName(WSText text) {
        this.objective.setDisplayName(text.toFormattingText());
    }

    @Override
    public EnumCriteria getCriteria() {
        return EnumCriteria.getBySpigotName(this.objective.getCriteria()).orElse(EnumCriteria.DUMMY);
    }

    @Override
    public Map<WSText, WSScore> getScores() {
        HashMap<WSText, WSScore> scores = new HashMap<WSText, WSScore>();
        try {
            Class<?> spigotObjectiveClass = NMSUtils.getOBCClass("scoreboard.CraftObjective");
            Class<?> spigotScoreboardClass = NMSUtils.getOBCClass("scoreboard.CraftScoreboard");
            Class<?> scoreClass = NMSUtils.getNMSClass("ScoreboardScore");
            Method getHandleObjectiveMethod = spigotObjectiveClass.getDeclaredMethod("getHandle", new Class[0]);
            Method getHandleScoreboardMethod = spigotScoreboardClass.getDeclaredMethod("getHandle", new Class[0]);
            getHandleObjectiveMethod.setAccessible(true);
            getHandleScoreboardMethod.setAccessible(true);
            Object objectiveHandled = getHandleObjectiveMethod.invoke((Object)this.objective, new Object[0]);
            Object scoreboardHandled = getHandleScoreboardMethod.invoke((Object)this.objective.getScoreboard(), new Object[0]);
            Collection netScores = (Collection)scoreboardHandled.getClass().getMethod("getScoresForObjective", objectiveHandled.getClass()).invoke(scoreboardHandled, objectiveHandled);
            netScores.forEach(score -> {
                try {
                    String name = (String)scoreClass.getMethod("getPlayerName", new Class[0]).invoke(score, new Object[0]);
                    int value = (Integer)scoreClass.getDeclaredMethod("getScore", new Class[0]).invoke(score, new Object[0]);
                    if (value < 1) {
                        return;
                    }
                    scores.put(WSText.getByFormattingText(name), new SpigotScore(this.objective.getScore(name)));
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            });
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return scores;
    }

    @Override
    public boolean hasScore(WSText name) {
        return this.getScores().containsKey(name);
    }

    @Override
    public WSScore getOrCreateScore(WSText name) {
        return new SpigotScore(this.objective.getScore(name.toFormattingText()));
    }

    @Override
    public boolean removeScore(WSText name) {
        try {
            Class<?> spigotObjectiveClass = NMSUtils.getOBCClass("scoreboard.CraftObjective");
            Class<?> spigotScoreboardClass = NMSUtils.getOBCClass("scoreboard.CraftScoreboard");
            Method getHandleObjectiveMethod = spigotObjectiveClass.getDeclaredMethod("getHandle", new Class[0]);
            Method getHandleScoreboardMethod = spigotScoreboardClass.getDeclaredMethod("getHandle", new Class[0]);
            getHandleObjectiveMethod.setAccessible(true);
            getHandleScoreboardMethod.setAccessible(true);
            Object objectiveHandled = getHandleObjectiveMethod.invoke((Object)this.objective, new Object[0]);
            Object scoreboardHandled = getHandleScoreboardMethod.invoke((Object)this.objective.getScoreboard(), new Object[0]);
            NMSUtils.getNMSClass("Scoreboard").getDeclaredMethod("resetPlayerScores", String.class, objectiveHandled.getClass()).invoke(scoreboardHandled, name.toFormattingText(), objectiveHandled);
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was trying to remove a score!");
            return false;
        }
        return true;
    }

    @Override
    public boolean removeScore(WSScore score) {
        try {
            Class<?> spigotObjectiveClass = NMSUtils.getOBCClass("scoreboard.CraftObjective");
            Class<?> spigotScoreboardClass = NMSUtils.getOBCClass("scoreboard.CraftScoreboard");
            Method getHandleObjectiveMethod = spigotObjectiveClass.getDeclaredMethod("getHandle", new Class[0]);
            Method getHandleScoreboardMethod = spigotScoreboardClass.getDeclaredMethod("getHandle", new Class[0]);
            getHandleObjectiveMethod.setAccessible(true);
            getHandleScoreboardMethod.setAccessible(true);
            Object objectiveHandled = getHandleObjectiveMethod.invoke((Object)this.objective, new Object[0]);
            Object scoreboardHandled = getHandleScoreboardMethod.invoke((Object)this.objective.getScoreboard(), new Object[0]);
            NMSUtils.getNMSClass("Scoreboard").getDeclaredMethod("resetPlayerScores", String.class, objectiveHandled.getClass()).invoke(scoreboardHandled, ((SpigotScore)score).getHandled().getEntry(), objectiveHandled);
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was trying to remove a score!");
            return false;
        }
        return true;
    }

    @Override
    public void removeAllScoresWithScore(int score) {
        this.getScores().values().stream().filter(target -> target.getScore() == score).forEach(this::removeScore);
    }

    @Override
    public Optional<WSScoreboard> getScoreboard() {
        try {
            return Optional.of(new SpigotScoreboard(this.objective.getScoreboard()));
        }
        catch (Throwable ex) {
            return Optional.empty();
        }
    }

    public Objective getHandled() {
        return this.objective;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpigotObjective objective1 = (SpigotObjective)o;
        return this.objective.equals(objective1.objective);
    }

    public int hashCode() {
        return this.objective.hashCode();
    }
}

