/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.scoreboard;

import com.degoos.wetsponge.enums.EnumCriteria;
import com.degoos.wetsponge.enums.EnumDisplaySlot;
import com.degoos.wetsponge.scoreboard.Spigot13Objective;
import com.degoos.wetsponge.scoreboard.Spigot13Team;
import com.degoos.wetsponge.scoreboard.WSObjective;
import com.degoos.wetsponge.scoreboard.WSScoreboard;
import com.degoos.wetsponge.scoreboard.WSTeam;
import com.degoos.wetsponge.scoreboard.WSUpdatableObjective;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.Validate;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class Spigot13Scoreboard
implements WSScoreboard {
    private Scoreboard scoreboard;

    public Spigot13Scoreboard(Scoreboard scoreboard) {
        Validate.notNull(scoreboard, "Scoreboard cannot be null!");
        this.scoreboard = scoreboard;
    }

    @Override
    public Optional<WSObjective> getObjective(String name) {
        Validate.notNull(name, "Name cannot be null!");
        return Optional.ofNullable(this.scoreboard.getObjective(name)).map(Spigot13Objective::new);
    }

    @Override
    public Optional<WSObjective> getObjective(EnumDisplaySlot displaySlot) {
        Validate.notNull((Object)displaySlot, "DisplaySlot cannot be null!");
        return Optional.ofNullable(this.scoreboard.getObjective(DisplaySlot.valueOf((String)displaySlot.getSpigotName()))).map(Spigot13Objective::new);
    }

    @Override
    public WSObjective getOrCreateObjective(String name, @Nullable WSText displayName, EnumCriteria criteria) {
        Validate.notNull((Object)criteria, "Criteria cannot be null!");
        Validate.notNull(name, "Name cannot be null!");
        Optional<WSObjective> optional = this.getObjective(name);
        if (optional.isPresent()) {
            return optional.get();
        }
        Spigot13Objective objective = new Spigot13Objective(this.scoreboard.registerNewObjective(name, criteria.getSpigotName()));
        objective.getHandled().setDisplayName(displayName == null ? name : displayName.toFormattingText());
        return objective;
    }

    @Override
    public void updateDisplaySlot(@Nullable WSObjective objective, EnumDisplaySlot displaySlot) {
        Validate.notNull((Object)displaySlot, "DisplaySlot cannot be null!");
        if (objective == null) {
            this.scoreboard.clearSlot(DisplaySlot.valueOf((String)displaySlot.getSpigotName()));
        } else {
            if (objective instanceof WSUpdatableObjective) {
                objective = ((WSUpdatableObjective)objective).getObjective();
            }
            ((Spigot13Objective)objective).getHandled().setDisplaySlot(DisplaySlot.valueOf((String)displaySlot.getSpigotName()));
        }
    }

    @Override
    public Set<WSObjective> getObjectives() {
        return this.scoreboard.getObjectives().stream().map(Spigot13Objective::new).collect(Collectors.toSet());
    }

    @Override
    public void removeObjective(WSObjective objective) {
        Validate.notNull(objective, "Objective cannot be null!");
        if (objective instanceof WSUpdatableObjective) {
            objective = ((WSUpdatableObjective)objective).getObjective();
        }
        if (this.getObjective(objective.getName()).isPresent()) {
            ((Spigot13Objective)objective).getHandled().unregister();
        }
    }

    @Override
    public void clearObjectives() {
        new HashSet(this.scoreboard.getObjectives()).forEach(Objective::unregister);
    }

    @Override
    public Optional<WSTeam> getTeam(String name) {
        Validate.notNull(name, "Name cannot be null!");
        return Optional.ofNullable(this.scoreboard.getTeam(name)).map(Spigot13Team::new);
    }

    @Override
    public boolean hasTeam(String name) {
        Validate.notNull(name, "Name cannot be null!");
        return this.getTeam(name).isPresent();
    }

    @Override
    public WSTeam getOrCreateTeam(String name) {
        Validate.notNull(name, "Name cannot be null!");
        Optional<WSTeam> optional = this.getTeam(name);
        return optional.orElseGet(() -> new Spigot13Team(this.scoreboard.registerNewTeam(name)));
    }

    @Override
    public Set<WSTeam> getTeams() {
        return this.scoreboard.getTeams().stream().map(Spigot13Team::new).collect(Collectors.toSet());
    }

    @Override
    public Optional<WSTeam> getMemberTeam(WSText member) {
        Validate.notNull(member, "Member cannot be null!");
        return this.getTeams().stream().filter(team -> team.hasMember(member)).findAny();
    }

    @Override
    public boolean unregisterTeam(WSTeam team) {
        Validate.notNull(team, "Team cannot be null!");
        return team.unregister();
    }

    @Override
    public void unregisterAllTeams() {
        this.getTeams().forEach(WSTeam::unregister);
    }

    public Scoreboard getHandled() {
        return this.scoreboard;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spigot13Scoreboard that = (Spigot13Scoreboard)o;
        return this.scoreboard.equals(that.scoreboard);
    }

    public int hashCode() {
        return this.scoreboard.hashCode();
    }
}

