/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.resource.sponge;

import com.degoos.wetsponge.user.SpongeGameProfile;
import com.degoos.wetsponge.user.WSGameProfile;
import java.net.URL;
import java.util.UUID;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.SkullTypes;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.property.ProfileProperty;

public class SpongeSkullBuilder {
    public String getTexture(GameProfile gameProfile) {
        return gameProfile.getPropertyMap().get("textures").stream().findAny().map(ProfileProperty::getValue).orElse(null);
    }

    public static void setTexture(URL texture, WSGameProfile profile) {
        SpongeSkullBuilder.setTexture(profile == null ? SpongeSkullBuilder.getEmptyGameProfile() : ((SpongeGameProfile)profile).getHandled(), SpongeSkullBuilder.getTexture(texture));
    }

    public static void setTexture(String texture, WSGameProfile profile) {
        SpongeSkullBuilder.setTexture(profile == null ? SpongeSkullBuilder.getEmptyGameProfile() : ((SpongeGameProfile)profile).getHandled(), texture);
    }

    public static GameProfile setTexture(GameProfile gameProfile, String texture) {
        if (texture == null) {
            gameProfile.getPropertyMap().removeAll("textures");
        } else {
            gameProfile.addProperty("textures", ProfileProperty.of((String)"textures", (String)texture));
        }
        return gameProfile;
    }

    public static String getTexture(URL url) {
        if (url == null) {
            return null;
        }
        return String.format("{textures:{SKIN:{url:\"%s\"}}}", url.toExternalForm());
    }

    public static String getTexture(String url) {
        if (url == null) {
            return null;
        }
        return String.format("{textures:{SKIN:{url:\"%s\"}}}", url);
    }

    public static GameProfile getGameProfileByName(String name) {
        return GameProfile.of((UUID)UUID.randomUUID(), (String)name);
    }

    public static WSGameProfile getWSGameProfileByName(String name) {
        return new SpongeGameProfile(SpongeSkullBuilder.getGameProfileByName(name));
    }

    public static GameProfile getEmptyGameProfile() {
        return GameProfile.of((UUID)UUID.randomUUID());
    }

    public static GameProfile getGameProfile(BlockState blockState) {
        return blockState.get(Keys.REPRESENTED_PLAYER).orElse(SpongeSkullBuilder.getEmptyGameProfile());
    }

    public static GameProfile getGameProfile(ItemStack itemStack) {
        return itemStack.get(Keys.REPRESENTED_PLAYER).orElse(SpongeSkullBuilder.getEmptyGameProfile());
    }

    public static ItemStack createItemStackByUnknownFormat(String string) {
        if (string.toLowerCase().startsWith("http:") || string.toLowerCase().startsWith("https:")) {
            return SpongeSkullBuilder.createItemStackByTexture(SpongeSkullBuilder.getTexture(string));
        }
        if (string.length() <= 16) {
            return SpongeSkullBuilder.createItemStackByPlayerName(string);
        }
        return SpongeSkullBuilder.createItemStackByTexture(string);
    }

    public static ItemStack createItemStackByTexture(String texture) {
        ItemStack itemStack = ItemStack.of((ItemType)ItemTypes.SKULL, (int)1);
        itemStack.offer(Keys.SKULL_TYPE, (Object)SkullTypes.PLAYER);
        itemStack.offer(Keys.REPRESENTED_PLAYER, (Object)SpongeSkullBuilder.setTexture(SpongeSkullBuilder.getGameProfile(itemStack), texture));
        return itemStack;
    }

    public static ItemStack createItemStackByURL(URL url) {
        ItemStack itemStack = ItemStack.of((ItemType)ItemTypes.SKULL, (int)1);
        itemStack.offer(Keys.SKULL_TYPE, (Object)SkullTypes.PLAYER);
        itemStack.offer(Keys.REPRESENTED_PLAYER, (Object)SpongeSkullBuilder.setTexture(SpongeSkullBuilder.getGameProfile(itemStack), SpongeSkullBuilder.getTexture(url)));
        return itemStack;
    }

    public static ItemStack createItemStackByPlayerName(String name) {
        ItemStack itemStack = ItemStack.of((ItemType)ItemTypes.SKULL, (int)1);
        itemStack.offer(Keys.SKULL_TYPE, (Object)SkullTypes.PLAYER);
        itemStack.offer(Keys.REPRESENTED_PLAYER, (Object)SpongeSkullBuilder.getGameProfileByName(name));
        return itemStack;
    }

    public static ItemStack updateItemStackByUnknownFormat(ItemStack itemStack, String string) {
        if (string.toLowerCase().startsWith("http:") || string.toLowerCase().startsWith("https:")) {
            return SpongeSkullBuilder.updateItemStackByTexture(itemStack, SpongeSkullBuilder.getTexture(string));
        }
        if (string.length() <= 16) {
            return SpongeSkullBuilder.updateItemStackByPlayerName(itemStack, string);
        }
        return SpongeSkullBuilder.updateItemStackByTexture(itemStack, string);
    }

    public static ItemStack updateItemStackByTexture(ItemStack itemStack, String texture) {
        itemStack.offer(Keys.REPRESENTED_PLAYER, (Object)SpongeSkullBuilder.setTexture(SpongeSkullBuilder.getGameProfile(itemStack), texture));
        return itemStack;
    }

    public static ItemStack updateItemStackByURL(ItemStack itemStack, URL url) {
        itemStack.offer(Keys.REPRESENTED_PLAYER, (Object)SpongeSkullBuilder.setTexture(SpongeSkullBuilder.getGameProfile(itemStack), SpongeSkullBuilder.getTexture(url)));
        return itemStack;
    }

    public static ItemStack updateItemStackByPlayerName(ItemStack itemStack, String name) {
        itemStack.offer(Keys.REPRESENTED_PLAYER, (Object)SpongeSkullBuilder.getGameProfileByName(name));
        return itemStack;
    }

    public static BlockState updateSkullByUnknownFormat(BlockState skull, String string) {
        if (string.toLowerCase().startsWith("http:") || string.toLowerCase().startsWith("https:")) {
            return SpongeSkullBuilder.updateSkullByTexture(skull, SpongeSkullBuilder.getTexture(string));
        }
        if (string.length() <= 16) {
            return SpongeSkullBuilder.updateSkullByPlayerName(skull, string);
        }
        return SpongeSkullBuilder.updateSkullByTexture(skull, string);
    }

    public static BlockState updateSkullByTexture(BlockState skull, String texture) {
        return skull.with(Keys.REPRESENTED_PLAYER, (Object)SpongeSkullBuilder.setTexture(SpongeSkullBuilder.getGameProfile(skull), texture)).orElse(skull);
    }

    public static BlockState updateSkullByURL(BlockState skull, URL url) {
        return skull.with(Keys.REPRESENTED_PLAYER, (Object)SpongeSkullBuilder.setTexture(SpongeSkullBuilder.getGameProfile(skull), SpongeSkullBuilder.getTexture(url))).orElse(skull);
    }

    public static BlockState updateSkullByPlayerName(BlockState skull, String name) {
        return skull.with(Keys.REPRESENTED_PLAYER, (Object)SpongeSkullBuilder.getGameProfileByName(name)).orElse(skull);
    }
}

