/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.resource.sponge;

import com.degoos.wetsponge.SpongeWetSponge;
import com.degoos.wetsponge.entity.living.player.SpongePlayer;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.parser.player.PlayerParser;
import com.degoos.wetsponge.resource.WSBungeeCord;
import com.degoos.wetsponge.text.WSText;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelBuf;
import org.spongepowered.api.network.RawDataListener;
import org.spongepowered.api.network.RemoteConnection;

public class SpongeBungeeCord
implements WSBungeeCord {
    private Object plugin = SpongeWetSponge.getInstance();
    private ChannelBinding.RawDataChannel chan = Sponge.getChannelRegistrar().createRawChannel(this.plugin, "BungeeCord");
    private ChannelListener listener = new ChannelListener();

    public SpongeBungeeCord() {
        this.chan.addListener(Platform.Type.SERVER, (RawDataListener)this.listener);
    }

    private void checkState() throws IllegalStateException {
        if (!Sponge.getGame().getState().equals((Object)GameState.SERVER_STARTED)) {
            throw new IllegalStateException("Server has not started!");
        }
    }

    private WSPlayer getWSPlayer() throws IllegalStateException {
        try {
            return PlayerParser.getPlayer(((Player)Sponge.getServer().getOnlinePlayers().iterator().next()).getUniqueId()).orElse(null);
        }
        catch (NoSuchElementException ex) {
            throw new WSBungeeCord.NoWSPlayerOnlineException();
        }
    }

    private Player getPlayer() throws IllegalStateException {
        try {
            return (Player)Sponge.getServer().getOnlinePlayers().iterator().next();
        }
        catch (NoSuchElementException ex) {
            throw new WSBungeeCord.NoWSPlayerOnlineException();
        }
    }

    private ChannelBuf getChannelBuf() {
        try {
            return (ChannelBuf)Class.forName("org.spongepowered.common.network.SpongeNetworkManager").getMethod("toChannelBuf", Class.forName("io.netty.buffer.ByteBuf")).invoke(null, Class.forName("io.netty.buffer.Unpooled").getMethod("buffer", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void connectWSPlayer(WSPlayer player, String server) {
        this.checkState();
        Preconditions.checkNotNull(player, "p");
        Preconditions.checkNotNull(server, "server");
        this.chan.sendTo(((SpongePlayer)player).getHandled(), buf -> buf.writeUTF("Connect").writeUTF(server));
    }

    @Override
    public void connectWSPlayer(String player, String server) {
        this.checkState();
        Preconditions.checkNotNull(player, "WSPlayer");
        Preconditions.checkNotNull(server, "server");
        this.chan.sendTo(this.getPlayer(), buf -> buf.writeUTF("ConnectOther").writeUTF(player).writeUTF(server));
    }

    @Override
    public CompletableFuture<InetSocketAddress> getWSPlayerIP(WSPlayer player) {
        this.checkState();
        Preconditions.checkNotNull(player, "WSPlayer");
        this.chan.sendTo(((SpongePlayer)player).getHandled(), buf -> buf.writeUTF("IP"));
        CompletableFuture<InetSocketAddress> addressCompletableFuture = new CompletableFuture<InetSocketAddress>();
        this.listener.map.put((buf, conn) -> buf.resetRead().readUTF().equals("IP") && conn.equals(player), buf -> addressCompletableFuture.complete(new InetSocketAddress(buf.readUTF(), buf.readInteger())));
        return addressCompletableFuture;
    }

    @Override
    public CompletableFuture<Integer> getWSPlayerCount(String server) {
        this.checkState();
        Preconditions.checkNotNull(server, "server");
        this.chan.sendTo(this.getPlayer(), buf -> buf.writeUTF("PlayerCount").writeUTF(server));
        CompletableFuture<Integer> count = new CompletableFuture<Integer>();
        this.listener.map.put((buf, conn) -> buf.resetRead().readUTF().equals("PlayerCount") && buf.readUTF().equals(server), buf -> count.complete(buf.readInteger()));
        return count;
    }

    @Override
    public CompletableFuture<Integer> getGlobalWSPlayerCount() {
        return this.getWSPlayerCount("ALL");
    }

    @Override
    public CompletableFuture<List<String>> getOnlineWSPlayers(String server) {
        this.checkState();
        Preconditions.checkNotNull(server, "server");
        this.chan.sendTo(this.getPlayer(), buf -> buf.writeUTF("PlayerList").writeUTF(server));
        CompletableFuture<List<String>> list = new CompletableFuture<List<String>>();
        this.listener.map.put((buf, conn) -> buf.resetRead().readUTF().equals("PlayerList") && buf.readUTF().equals(server), buf -> list.complete(ImmutableList.copyOf(buf.readUTF().split(", "))));
        return list;
    }

    @Override
    public CompletableFuture<List<String>> getAllOnlineWSPlayers() {
        return this.getOnlineWSPlayers("ALL");
    }

    @Override
    public CompletableFuture<List<String>> getServerList() {
        this.checkState();
        CompletableFuture<List<String>> list = new CompletableFuture<List<String>>();
        this.chan.sendTo(this.getPlayer(), buf -> buf.writeUTF("GetServers"));
        this.listener.map.put((buf, conn) -> buf.resetRead().readUTF().equals("GetServers"), buf -> list.complete(ImmutableList.copyOf(buf.readUTF().split(", "))));
        return list;
    }

    @Override
    public void sendMessage(String WSPlayer2, WSText message) {
        this.checkState();
        Preconditions.checkNotNull(WSPlayer2, "WSPlayer");
        Preconditions.checkNotNull(message, "message");
        this.chan.sendTo(this.getPlayer(), buf -> buf.writeUTF("Message").writeUTF(WSPlayer2).writeUTF(message.toFormattingText()));
    }

    @Override
    public CompletableFuture<String> getServerName() {
        this.checkState();
        this.chan.sendTo(this.getPlayer(), buf -> buf.writeUTF("GetServer"));
        CompletableFuture<String> message = new CompletableFuture<String>();
        this.listener.map.put((buf, conn) -> buf.resetRead().readUTF().equals("GetServer"), buf -> message.complete(buf.readUTF()));
        return message;
    }

    @Override
    public void sendServerPluginMessage(byte[] payload, String channel, String server) {
        ByteBuffer newPayload = ByteBuffer.wrap(payload);
        this.checkState();
        Preconditions.checkNotNull(payload, "payload");
        Preconditions.checkNotNull(channel, "channel");
        Preconditions.checkNotNull(server, "server");
        ChannelBuf buffer = this.getChannelBuf();
        buffer.resetRead();
        this.chan.sendTo(this.getPlayer(), buf -> buf.writeUTF("Forward").writeUTF(server).writeUTF(channel).writeByteArray(payload));
    }

    @Override
    public void sendGlobalPluginMessage(byte[] payload, String channel) {
        this.sendServerPluginMessage(payload, channel, "ALL");
    }

    @Override
    public void sendWSPlayerPluginMessage(byte[] payload, String channel, String WSPlayer2) {
        this.checkState();
        Preconditions.checkNotNull(payload, "payload");
        Preconditions.checkNotNull(channel, "channel");
        Preconditions.checkNotNull(WSPlayer2, "WSPlayer");
        ChannelBuf buffer = this.getChannelBuf();
        buffer.resetRead();
        this.chan.sendTo(this.getPlayer(), buf -> buf.writeUTF("ForwardToPlayer").writeUTF(WSPlayer2).writeUTF(channel).writeByteArray(payload));
    }

    @Override
    public CompletableFuture<UUID> getRealUUID(WSPlayer player) {
        this.checkState();
        Preconditions.checkNotNull(player, "WSPlayer");
        this.chan.sendTo(((SpongePlayer)player).getHandled(), buf -> buf.writeUTF("UUID"));
        CompletableFuture<UUID> id = new CompletableFuture<UUID>();
        this.listener.map.put((buf, conn) -> buf.resetRead().readUTF().equals("UUID") && conn.equals(player), buf -> id.complete(UUID.fromString(buf.readUTF())));
        return id;
    }

    @Override
    public CompletableFuture<UUID> getRealUUID(String WSPlayer2) {
        this.checkState();
        Preconditions.checkNotNull(WSPlayer2, "WSPlayer");
        this.chan.sendTo(this.getPlayer(), buf -> buf.writeUTF("UUIDOther").writeUTF(WSPlayer2));
        CompletableFuture<UUID> id = new CompletableFuture<UUID>();
        this.listener.map.put((buf, conn) -> buf.resetRead().readUTF().equals("UUIDOther") && buf.readUTF().equals(WSPlayer2), buf -> id.complete(UUID.fromString(buf.readUTF())));
        return id;
    }

    @Override
    public CompletableFuture<InetSocketAddress> getServerIP(String server) {
        this.checkState();
        Preconditions.checkNotNull(server, "server");
        this.chan.sendTo(this.getPlayer(), buf -> buf.writeUTF("ServerIP").writeUTF(server));
        CompletableFuture<InetSocketAddress> address = new CompletableFuture<InetSocketAddress>();
        this.listener.map.put((buf, conn) -> buf.resetRead().readUTF().equals("ServerIP") && buf.readUTF().equals(server), buf -> address.complete(new InetSocketAddress(buf.readUTF(), (int)buf.readShort())));
        return address;
    }

    @Override
    public void kickWSPlayer(String WSPlayer2, WSText reason) {
        this.checkState();
        Preconditions.checkNotNull(WSPlayer2, "WSPlayer");
        Preconditions.checkNotNull(reason, "reason");
        this.chan.sendTo(this.getPlayer(), buf -> buf.writeUTF("KickWSPlayer").writeUTF(WSPlayer2).writeUTF(reason.toFormattingText()));
    }

    private static class ChannelListener
    implements RawDataListener {
        Map<BiPredicate<ChannelBuf, RemoteConnection>, Consumer<ChannelBuf>> map = Maps.newConcurrentMap();

        private ChannelListener() {
        }

        public void handlePayload(ChannelBuf data, RemoteConnection connection, Platform.Type side) {
            this.map.keySet().stream().filter(pred -> pred.test(data, connection)).findFirst().ifPresent(pred -> {
                this.map.get(pred).accept(data);
                this.map.remove(pred);
            });
        }
    }
}

