/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.resource.spigot;

import com.degoos.wetsponge.user.SpigotGameProfile;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SpigotSkullBuilder {
    public String getTexture(GameProfile gameProfile) {
        return gameProfile.getProperties().get((Object)"textures").stream().findAny().map(Property::getValue).orElse(null);
    }

    public static void setTexture(URL texture, WSGameProfile profile) {
        SpigotSkullBuilder.setTexture(profile == null ? SpigotSkullBuilder.getEmptyGameProfile() : ((SpigotGameProfile)profile).getHandled(), SpigotSkullBuilder.getTexture(texture));
    }

    public static void setTexture(String texture, WSGameProfile profile) {
        SpigotSkullBuilder.setTexture(profile == null ? SpigotSkullBuilder.getEmptyGameProfile() : ((SpigotGameProfile)profile).getHandled(), texture);
    }

    public static GameProfile setTexture(GameProfile gameProfile, String texture) {
        if (texture == null) {
            gameProfile.getProperties().removeAll((Object)"textures");
        } else {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(texture.getBytes())));
        }
        return gameProfile;
    }

    public static String getTexture(URL url) {
        if (url == null) {
            return null;
        }
        return new String(Base64.getEncoder().encode(String.format("{\"textures\":{\"SKIN\":{\"url\":\"%s\"}}}", url.toExternalForm()).getBytes()));
    }

    public static String getTexture(String url) {
        if (url == null) {
            return null;
        }
        return new String(Base64.getEncoder().encode(String.format("{\"textures\":{\"SKIN\":{\"url\":\"%s\"}}}", url).getBytes()));
    }

    public static GameProfile getGameProfileByName(String name) {
        return new GameProfile(UUID.randomUUID(), name);
    }

    public static WSGameProfile getWSGameProfileByName(String name) {
        return new SpigotGameProfile(SpigotSkullBuilder.getGameProfile(name));
    }

    public static GameProfile getEmptyGameProfile() {
        return new GameProfile(UUID.randomUUID(), null);
    }

    public static void injectGameProfile(Object object, GameProfile gameProfile) {
        try {
            ReflectionUtils.setFirstObject(object.getClass(), GameProfile.class, object, gameProfile);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static GameProfile getGameProfile(Object object) {
        return ReflectionUtils.getFirstObjectOrElse(object.getClass(), GameProfile.class, object, SpigotSkullBuilder.getEmptyGameProfile());
    }

    public static ItemStack createItemStackByUnknownFormat(String string) {
        if (string.toLowerCase().startsWith("http:") || string.toLowerCase().startsWith("https:")) {
            return SpigotSkullBuilder.createItemStackByTexture(SpigotSkullBuilder.getTexture(string));
        }
        if (string.length() <= 16) {
            return SpigotSkullBuilder.createItemStackByPlayerName(string);
        }
        return SpigotSkullBuilder.createItemStackByTexture(string);
    }

    public static ItemStack createItemStackByTexture(String texture) {
        ItemStack itemStack = new ItemStack(Material.SKULL_ITEM, 1, 3);
        SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
        SpigotSkullBuilder.injectGameProfile(meta, SpigotSkullBuilder.setTexture(SpigotSkullBuilder.getGameProfile(meta), texture));
        itemStack.setItemMeta((ItemMeta)meta);
        return itemStack;
    }

    public static ItemStack createItemStackByURL(URL url) {
        ItemStack itemStack = new ItemStack(Material.SKULL_ITEM, 1, 3);
        SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
        SpigotSkullBuilder.injectGameProfile(meta, SpigotSkullBuilder.setTexture(SpigotSkullBuilder.getGameProfile(meta), SpigotSkullBuilder.getTexture(url)));
        itemStack.setItemMeta((ItemMeta)meta);
        return itemStack;
    }

    public static ItemStack createItemStackByPlayerName(String name) {
        ItemStack itemStack = new ItemStack(Material.SKULL_ITEM, 1, 3);
        SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
        meta.setOwner(name);
        SpigotSkullBuilder.injectGameProfile(meta, SpigotSkullBuilder.getGameProfileByName(name));
        itemStack.setItemMeta((ItemMeta)meta);
        return itemStack;
    }

    public static ItemStack updateItemStackByUnknownFormat(ItemStack itemStack, String string) {
        if (string.toLowerCase().startsWith("http:") || string.toLowerCase().startsWith("https:")) {
            return SpigotSkullBuilder.updateItemStackByTexture(itemStack, SpigotSkullBuilder.getTexture(string));
        }
        if (string.length() <= 16) {
            return SpigotSkullBuilder.updateItemStackByPlayerName(itemStack, string);
        }
        return SpigotSkullBuilder.updateItemStackByTexture(itemStack, string);
    }

    public static ItemStack updateItemStackByTexture(ItemStack itemStack, String texture) {
        SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
        SpigotSkullBuilder.injectGameProfile(meta, SpigotSkullBuilder.setTexture(SpigotSkullBuilder.getGameProfile(meta), texture));
        itemStack.setItemMeta((ItemMeta)meta);
        return itemStack;
    }

    public static ItemStack updateItemStackByURL(ItemStack itemStack, URL url) {
        SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
        SpigotSkullBuilder.injectGameProfile(meta, SpigotSkullBuilder.setTexture(SpigotSkullBuilder.getGameProfile(meta), SpigotSkullBuilder.getTexture(url)));
        itemStack.setItemMeta((ItemMeta)meta);
        return itemStack;
    }

    public static ItemStack updateItemStackByPlayerName(ItemStack itemStack, String name) {
        SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
        SpigotSkullBuilder.injectGameProfile(meta, SpigotSkullBuilder.getGameProfileByName(name));
        itemStack.setItemMeta((ItemMeta)meta);
        return itemStack;
    }

    public static void updateSkullByUnknownFormat(Skull skull, String string) {
        if (string.toLowerCase().startsWith("http:") || string.toLowerCase().startsWith("https:")) {
            SpigotSkullBuilder.updateSkullByTexture(skull, SpigotSkullBuilder.getTexture(string));
        } else if (string.length() <= 16) {
            SpigotSkullBuilder.updateSkullByPlayerName(skull, string);
        } else {
            SpigotSkullBuilder.updateSkullByTexture(skull, string);
        }
    }

    public static void updateSkullByTexture(Skull skull, String texture) {
        SpigotSkullBuilder.injectGameProfile(skull, SpigotSkullBuilder.setTexture(SpigotSkullBuilder.getGameProfile(skull), texture));
    }

    public static void updateSkullByURL(Skull skull, URL url) {
        SpigotSkullBuilder.injectGameProfile(skull, SpigotSkullBuilder.setTexture(SpigotSkullBuilder.getGameProfile(skull), SpigotSkullBuilder.getTexture(url)));
    }

    public static void updateSkullByPlayerName(Skull skull, String name) {
        SpigotSkullBuilder.injectGameProfile(skull, SpigotSkullBuilder.getGameProfileByName(name));
    }
}

