/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.resource.spigot;

import com.degoos.wetsponge.entity.living.player.SpigotPlayer;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.parser.player.PlayerParser;
import com.degoos.wetsponge.resource.WSBungeeCord;
import com.degoos.wetsponge.resource.spigot.SpigotBungeeRequest;
import com.degoos.wetsponge.text.WSText;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class SpigotBungeeCord
implements WSBungeeCord,
PluginMessageListener {
    private List<SpigotBungeeRequest> requests;
    private JavaPlugin javaPlugin;

    public SpigotBungeeCord(JavaPlugin javaPlugin) {
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)javaPlugin, "BungeeCord");
        Bukkit.getServer().getMessenger().registerIncomingPluginChannel((Plugin)javaPlugin, "BungeeCord", (PluginMessageListener)this);
        this.requests = new ArrayList<SpigotBungeeRequest>();
        this.javaPlugin = javaPlugin;
    }

    private WSPlayer getWSPlayer() throws IllegalStateException {
        try {
            return PlayerParser.getPlayer(((Player)Bukkit.getOnlinePlayers().iterator().next()).getUniqueId()).orElse(null);
        }
        catch (NoSuchElementException ex) {
            throw new WSBungeeCord.NoWSPlayerOnlineException();
        }
    }

    private Player getPlayer() throws IllegalStateException {
        try {
            return (Player)Bukkit.getOnlinePlayers().iterator().next();
        }
        catch (NoSuchElementException ex) {
            throw new WSBungeeCord.NoWSPlayerOnlineException();
        }
    }

    @Override
    public void connectWSPlayer(WSPlayer player, String server) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Connect");
        out.writeUTF(server);
        ((SpigotPlayer)player).getHandled().sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
    }

    @Override
    public void connectWSPlayer(String player, String server) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("ConnectOther");
        out.writeUTF(player);
        out.writeUTF(server);
        this.getPlayer().sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
    }

    @Override
    public CompletableFuture<InetSocketAddress> getWSPlayerIP(WSPlayer player) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("IP");
        ((SpigotPlayer)player).getHandled().sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
        CompletableFuture<InetSocketAddress> addressCompletableFuture = new CompletableFuture<InetSocketAddress>();
        SpigotBungeeRequest request = new SpigotBungeeRequest(((SpigotPlayer)player).getHandled(), "IP", addressCompletableFuture);
        this.requests.add(request);
        return addressCompletableFuture;
    }

    @Override
    public CompletableFuture<Integer> getWSPlayerCount(String server) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("PlayerCount");
        out.writeUTF(server);
        Player player = this.getPlayer();
        player.sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
        CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        SpigotBungeeRequest request = new SpigotBungeeRequest(player, "PlayerCount;" + server, completableFuture);
        this.requests.add(request);
        return completableFuture;
    }

    @Override
    public CompletableFuture<Integer> getGlobalWSPlayerCount() {
        return this.getWSPlayerCount("ALL");
    }

    @Override
    public CompletableFuture<List<String>> getOnlineWSPlayers(String server) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("PlayerList");
        out.writeUTF(server);
        Player player = this.getPlayer();
        player.sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
        CompletableFuture<List<String>> completableFuture = new CompletableFuture<List<String>>();
        SpigotBungeeRequest request = new SpigotBungeeRequest(player, "PlayerList;" + server, completableFuture);
        this.requests.add(request);
        return completableFuture;
    }

    @Override
    public CompletableFuture<List<String>> getAllOnlineWSPlayers() {
        return this.getOnlineWSPlayers("ALL");
    }

    @Override
    public CompletableFuture<List<String>> getServerList() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("GetServers");
        Player player = this.getPlayer();
        player.sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
        CompletableFuture<List<String>> completableFuture = new CompletableFuture<List<String>>();
        SpigotBungeeRequest request = new SpigotBungeeRequest(player, "GetServers", completableFuture);
        this.requests.add(request);
        return completableFuture;
    }

    @Override
    public void sendMessage(String player, WSText message) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Message");
        out.writeUTF(player);
        out.writeUTF(message.toFormattingText());
        this.getPlayer().sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
    }

    @Override
    public CompletableFuture<String> getServerName() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("GetServer");
        Player player = this.getPlayer();
        player.sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        SpigotBungeeRequest request = new SpigotBungeeRequest(player, "GetServer", completableFuture);
        this.requests.add(request);
        return completableFuture;
    }

    @Override
    public void sendServerPluginMessage(byte[] payload, String channel, String server) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Forward");
        out.writeUTF(server);
        out.writeUTF(channel);
        this.getPlayer().sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
    }

    @Override
    public void sendGlobalPluginMessage(byte[] payload, String channel) {
        this.sendServerPluginMessage(payload, channel, "ALL");
    }

    @Override
    public void sendWSPlayerPluginMessage(byte[] payload, String channel, String player) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("ForwardToPlayer");
        out.writeUTF(player);
        out.writeUTF(channel);
        this.getPlayer().sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
    }

    @Override
    public CompletableFuture<UUID> getRealUUID(WSPlayer player) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("UUID");
        ((SpigotPlayer)player).getHandled().sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
        CompletableFuture<UUID> completableFuture = new CompletableFuture<UUID>();
        SpigotBungeeRequest request = new SpigotBungeeRequest(((SpigotPlayer)player).getHandled(), "UUID", completableFuture);
        this.requests.add(request);
        return completableFuture;
    }

    @Override
    public CompletableFuture<UUID> getRealUUID(String player) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("UUIDOther");
        out.writeUTF(player);
        Player sendPlayer = this.getPlayer();
        sendPlayer.sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
        CompletableFuture<UUID> completableFuture = new CompletableFuture<UUID>();
        SpigotBungeeRequest request = new SpigotBungeeRequest(sendPlayer, "UUIDOther;" + player, completableFuture);
        this.requests.add(request);
        return completableFuture;
    }

    @Override
    public CompletableFuture<InetSocketAddress> getServerIP(String server) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("ServerIP");
        out.writeUTF(server);
        Player player = this.getPlayer();
        player.sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
        CompletableFuture<InetSocketAddress> completableFuture = new CompletableFuture<InetSocketAddress>();
        SpigotBungeeRequest request = new SpigotBungeeRequest(player, "ServerIP;" + server, completableFuture);
        this.requests.add(request);
        return completableFuture;
    }

    @Override
    public void kickWSPlayer(String player, WSText reason) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("KickPlayer");
        out.writeUTF(player);
        out.writeUTF(reason.toFormattingText());
        this.getPlayer().sendPluginMessage((Plugin)this.javaPlugin, "BungeeCord", out.toByteArray());
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (channel.equals("BungeeCord")) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput(message);
        String requestString = in.readUTF();
        List playerRequests = this.requests.stream().filter(request -> request.getPlayer().equals(player)).collect(Collectors.toList());
        if (requestString.equalsIgnoreCase("IP")) {
            String ip = in.readUTF();
            int port = in.readInt();
            playerRequests.stream().filter(request -> request.getRequest().equalsIgnoreCase("IP")).collect(Collectors.toList()).forEach(request -> {
                request.getCompletableFuture().complete(new InetSocketAddress(ip, port));
                this.requests.remove(request);
            });
        } else if (requestString.equalsIgnoreCase("PlayerCount")) {
            String server = in.readUTF();
            int count = in.readInt();
            playerRequests.stream().filter(request -> request.getRequest().startsWith("PlayerCount") && request.getRequest().split(";")[1].equals(server)).forEach(request -> {
                request.getCompletableFuture().complete(count);
                this.requests.remove(request);
            });
        } else if (requestString.equalsIgnoreCase("PlayerList")) {
            String server = in.readUTF();
            List<String> list = Arrays.asList(in.readUTF().split(", "));
            playerRequests.stream().filter(request -> request.getRequest().startsWith("PlayerList") && request.getRequest().split(";")[1].equals(server)).forEach(request -> {
                request.getCompletableFuture().complete(list);
                this.requests.remove(request);
            });
        } else if (requestString.equalsIgnoreCase("GetServers")) {
            List<String> list = Arrays.asList(in.readUTF().split(", "));
            playerRequests.stream().filter(request -> request.getRequest().equalsIgnoreCase("GetServers")).forEach(request -> {
                request.getCompletableFuture().complete(list);
                this.requests.remove(request);
            });
        } else if (requestString.equalsIgnoreCase("GetServer")) {
            String server = in.readUTF();
            playerRequests.stream().filter(request -> request.getRequest().equalsIgnoreCase("GetServer")).forEach(request -> {
                request.getCompletableFuture().complete(server);
                this.requests.remove(request);
            });
        } else if (requestString.equalsIgnoreCase("UUID")) {
            UUID uuid = UUID.fromString(in.readUTF());
            playerRequests.stream().filter(request -> request.getRequest().equalsIgnoreCase("UUID")).forEach(request -> {
                request.getCompletableFuture().complete(uuid);
                this.requests.remove(request);
            });
        } else if (requestString.equalsIgnoreCase("UUIDOther")) {
            String playerName = in.readUTF();
            UUID uuid = UUID.fromString(in.readUTF());
            playerRequests.stream().filter(request -> request.getRequest().startsWith("UUIDOther") && request.getRequest().split(";")[1].equals(playerName)).forEach(request -> {
                request.getCompletableFuture().complete(uuid);
                this.requests.remove(request);
            });
        } else if (requestString.equalsIgnoreCase("ServerIp")) {
            String serverName = in.readUTF();
            String ip = in.readUTF();
            int port = in.readUnsignedShort();
            playerRequests.stream().filter(request -> request.getRequest().startsWith("ServerIp") && request.getRequest().split(";")[1].equals(serverName)).forEach(request -> {
                request.getCompletableFuture().complete(new InetSocketAddress(ip, port));
                this.requests.remove(request);
            });
        }
    }
}

