/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.plugin;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.config.WetSpongeConfig;
import com.degoos.wetsponge.enums.EnumTextColor;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import java.util.Objects;

public class WSPluginLogger {
    private final String id;
    private final WSText banner;
    private static final WSText close = WSText.builder("] ").color(EnumTextColor.YELLOW).build();

    public WSPluginLogger(String id) {
        this.id = id;
        this.banner = WSText.builder("[" + id + " -> ").color(EnumTextColor.YELLOW).build();
    }

    public void sendError(String string) {
        this.sendError(WSText.of(string));
    }

    public void sendWarning(String string) {
        this.sendWarning(WSText.of(string));
    }

    public void sendInfo(String string) {
        this.sendInfo(WSText.of(string));
    }

    public void sendDone(String string) {
        this.sendDone(WSText.of(string));
    }

    public void sendDebug(String string) {
        if (WetSpongeConfig.getConfig().getBoolean("debug", false)) {
            this.send(WSText.of(string), WSText.builder("Debug").color(EnumTextColor.GRAY).build(), EnumTextColor.GRAY);
        }
    }

    public void sendError(WSText text) {
        this.send(text, WSText.builder("Error").color(EnumTextColor.RED).build(), EnumTextColor.RED);
    }

    public void sendWarning(WSText text) {
        this.send(text, WSText.builder("Warning").color(EnumTextColor.LIGHT_PURPLE).build(), EnumTextColor.LIGHT_PURPLE);
    }

    public void sendInfo(WSText text) {
        this.send(text, WSText.builder("Info").color(EnumTextColor.AQUA).build(), EnumTextColor.AQUA);
    }

    public void sendDone(WSText text) {
        this.send(text, WSText.builder("Done").color(EnumTextColor.GREEN).build(), EnumTextColor.GREEN);
    }

    public void sendDebug(WSText text) {
        if (WetSpongeConfig.getConfig().getBoolean("debug", false)) {
            this.send(text, WSText.builder("Debug").color(EnumTextColor.GRAY).build(), EnumTextColor.GRAY);
        }
    }

    private void send(WSText text, WSText type, EnumTextColor color) {
        WetSponge.getServer().getConsole().sendMessage(this.banner.toBuilder().append(type).append(close).append(WSText.builder("").color(color).append(text).build()).build());
    }

    public void printException(Throwable ex, String info) {
        this.printException(ex, WSText.of(info));
    }

    public void printException(Throwable ex, WSText info) {
        this.printException(ex, info, false);
    }

    private void printException(Throwable ex, WSText info, boolean causedBy) {
        new Thread(() -> {
            try {
                if (!causedBy) {
                    this.sendError("--------------------------------------------");
                    this.sendError(info);
                }
                this.sendError("");
                this.sendError(WSText.of("Type: ", WSText.of(ex.getClass().getName(), EnumTextColor.YELLOW)));
                this.sendError("");
                this.sendError(WSText.of("Description: ", WSText.of(ex.getLocalizedMessage() == null ? "-" : ex.getLocalizedMessage(), EnumTextColor.YELLOW)));
                try {
                    this.sendError(WSText.of("Cause: ", WSText.of(ex.getCause() == null || Objects.equals(ex.getCause().getLocalizedMessage(), "") ? "-" : ex.getCause().getLocalizedMessage(), EnumTextColor.YELLOW)));
                }
                catch (Exception e) {
                    this.sendError(WSText.of("Cause: -"));
                }
                this.sendError("");
                this.sendError("StackTrace:");
                for (StackTraceElement stackTraceElement : ex.getStackTrace()) {
                    this.sendError(WSPluginLogger.getColoredStackTrace(stackTraceElement));
                }
                if (ex.getCause() == null) {
                    this.sendError("");
                    String[] pastedata = InternalLogger.getHasteStackTraceURL(ex, info, ex.getStackTrace(), this.id);
                    this.sendError(WSText.builder(WSText.of("Error uploaded to: ", EnumTextColor.AQUA)).append(WSText.of(pastedata[0], EnumTextColor.YELLOW)).build());
                    this.sendError(WSText.builder(WSText.of("Error saved in: ", EnumTextColor.AQUA)).append(WSText.of(pastedata[1], EnumTextColor.YELLOW)).build());
                    this.sendError("");
                    this.sendError("--------------------------------------------");
                } else {
                    this.sendError("");
                    this.sendError("Caused by:");
                    this.printException(ex.getCause(), info, true);
                }
            }
            catch (Exception ex2) {
                ex.printStackTrace();
                ex2.printStackTrace();
            }
        }).start();
    }

    private static WSText getColoredStackTrace(StackTraceElement element) {
        WSText methodDataText;
        if (element.isNativeMethod()) {
            methodDataText = WSText.of(" (", EnumTextColor.GREEN, WSText.of("Native method", EnumTextColor.YELLOW, WSText.of(")", EnumTextColor.GREEN)));
        } else {
            WSText.Builder builder = WSText.builder(" (").color(EnumTextColor.GREEN);
            if (element.getFileName() != null && element.getLineNumber() >= 0) {
                builder.append(WSText.of(element.getFileName(), EnumTextColor.YELLOW));
                builder.append(WSText.of(":", EnumTextColor.GREEN));
                builder.append(WSText.of(String.valueOf(element.getLineNumber()), EnumTextColor.YELLOW));
                builder.append(WSText.of(")", EnumTextColor.GREEN));
            } else {
                builder.append(WSText.of(element.getFileName() != null ? element.getFileName() : "Unknown Source", EnumTextColor.YELLOW));
                builder.append(WSText.of(")", EnumTextColor.GREEN));
            }
            methodDataText = builder.build();
        }
        WSText classText = WSText.of(element.getMethodName(), EnumTextColor.LIGHT_PURPLE, methodDataText);
        return WSText.of("- " + element.getClassName() + ".", EnumTextColor.RED, classText);
    }
}

