/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.plugin;

import com.degoos.wetsponge.config.ConfigAccessor;
import com.degoos.wetsponge.exception.plugin.WSInvalidDescriptionException;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public final class WSPluginDescription {
    String rawName = null;
    private String name = null;
    private String main = null;
    private List<String> depend = ImmutableList.of();
    private List<String> softDepend = ImmutableList.of();
    private String version = null;
    private String description = null;
    private List<String> authors = null;
    private String website = null;
    private ConfigAccessor configAccessor;

    public WSPluginDescription(InputStream stream) throws WSInvalidDescriptionException {
        this.configAccessor = new ConfigAccessor(stream);
        this.loadMap(this.configAccessor);
    }

    public WSPluginDescription(Reader reader) throws WSInvalidDescriptionException {
        this.configAccessor = new ConfigAccessor(reader);
        this.loadMap(this.configAccessor);
    }

    public WSPluginDescription(String pluginName, String pluginVersion, String mainClass) {
        this.name = pluginName.replace(' ', '_');
        this.version = pluginVersion;
        this.main = mainClass;
    }

    private static List<String> makePluginNameList(ConfigAccessor configAccessor, String key) throws WSInvalidDescriptionException {
        return configAccessor.getStringList(key).stream().map(string -> string.replace(' ', '_')).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMain() {
        return this.main;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public String getWebsite() {
        return this.website;
    }

    public List<String> getDepend() {
        return this.depend;
    }

    public List<String> getSoftDepend() {
        return this.softDepend;
    }

    public String getFullName() {
        return this.name + " v" + this.version;
    }

    public void save(Writer writer) {
        if (this.configAccessor == null) {
            new Yaml().dump(this.saveMap(), writer);
        } else {
            this.configAccessor.save(writer);
        }
    }

    private void loadMap(ConfigAccessor accessor) throws WSInvalidDescriptionException {
        this.name = this.rawName = accessor.getString("name").replace(" ", "");
        if (this.name == null) {
            throw new WSInvalidDescriptionException("name is not defined");
        }
        if (!this.name.matches("^[A-Za-z0-9 _.-]+$")) {
            throw new WSInvalidDescriptionException("name '" + this.name + "' contains invalid characters.");
        }
        this.name = this.name.replace(' ', '_');
        this.version = this.configAccessor.getString("version");
        if (this.version == null) {
            throw new WSInvalidDescriptionException("version is not defined");
        }
        this.main = this.configAccessor.getString("main");
        if (this.main == null) {
            throw new WSInvalidDescriptionException("main is not defined");
        }
        this.depend = WSPluginDescription.makePluginNameList(this.configAccessor, "depend");
        this.softDepend = WSPluginDescription.makePluginNameList(this.configAccessor, "softdepend");
        if (this.configAccessor.contains("website")) {
            this.website = this.configAccessor.getString("website");
        }
        if (this.configAccessor.contains("description")) {
            this.description = this.configAccessor.getString("description");
        }
        this.authors = this.configAccessor.contains("authors") ? this.configAccessor.getStringList("authors") : new ArrayList<String>();
    }

    private Map<String, Object> saveMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("main", this.main);
        map.put("version", this.version);
        if (this.depend != null) {
            map.put("depend", this.depend);
        }
        if (this.softDepend != null) {
            map.put("softdepend", this.softDepend);
        }
        if (this.website != null) {
            map.put("website", this.website);
        }
        if (this.description != null) {
            map.put("description", this.description);
        } else if (this.authors.size() > 1) {
            map.put("authors", this.authors);
        }
        return map;
    }

    public String getRawName() {
        return this.rawName;
    }
}

