/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.plugin;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.plugin.WSPluginClassLoader;
import com.degoos.wetsponge.plugin.WSPluginDescription;
import com.degoos.wetsponge.plugin.WSPluginLogger;
import com.degoos.wetsponge.plugin.WSPluginManager;
import com.degoos.wetsponge.util.Validate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.LogManager;
import java.util.stream.Collectors;

public class WSPlugin {
    private WSPluginClassLoader classLoader;
    private WSPluginDescription pluginDescription;
    private String id;
    private boolean enabled;
    private File dataFolder;
    private Set<WSPlugin> dependencies;
    private Set<WSPlugin> enabledSoftDependencies;
    private WSPluginLogger logger;

    protected void init(WSPluginClassLoader classLoader, WSPluginDescription pluginDescription) {
        LogManager.getLogManager().reset();
        Validate.notNull(classLoader, "Classloader cannot be null!");
        Validate.notNull(pluginDescription, "Plugin description cannot be null!");
        this.classLoader = classLoader;
        this.pluginDescription = pluginDescription;
        this.id = pluginDescription.getName();
        this.logger = new WSPluginLogger(this.id);
        this.dataFolder = new File(WetSponge.getPluginManager().getPluginFolder(), this.id);
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        } else if (this.dataFolder.isFile()) {
            this.dataFolder.delete();
            this.dataFolder.mkdirs();
        }
        this.dependencies = pluginDescription.getDepend().stream().map(target -> WSPluginManager.getInstance().getPlugin((String)target).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
        this.enabledSoftDependencies = pluginDescription.getSoftDepend().stream().map(target -> WSPluginManager.getInstance().getPlugin((String)target).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
        this.enabled = false;
    }

    public void onEnable() {
    }

    public void onDisable() {
    }

    public WSPluginClassLoader getClassLoader() {
        return this.classLoader;
    }

    public WSPluginDescription getPluginDescription() {
        return this.pluginDescription;
    }

    public String getId() {
        return this.id;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public WSPluginLogger getLogger() {
        return this.logger;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        WetSponge.getTimings().assignPluginToThread(this);
        WetSponge.getTimings().startTiming(this.getId() + (enabled ? " enabling" : " disabling"));
        if (enabled) {
            this.onEnable();
        } else {
            this.onDisable();
        }
        WetSponge.getTimings().stopTiming();
        WetSponge.getTimings().assignPluginToThread(null);
    }

    public Set<WSPlugin> getDependencies() {
        return new HashSet<WSPlugin>(this.dependencies);
    }

    public boolean isDependency(WSPlugin plugin) {
        return this.dependencies.contains(plugin);
    }

    public Set<WSPlugin> getEnabledSoftDependencies() {
        return this.enabledSoftDependencies;
    }

    public boolean isSoftDependency(WSPlugin plugin) {
        return this.enabledSoftDependencies.contains(plugin);
    }

    public InputStream getResource(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Filename cannot be null");
        }
        try {
            URL url = this.classLoader.getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException var4) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WSPlugin wsPlugin = (WSPlugin)o;
        return this.id.equals(wsPlugin.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    static {
        LogManager.getLogManager().reset();
    }
}

