/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.particle;

import com.degoos.wetsponge.bridge.particle.BridgeParticles;
import com.degoos.wetsponge.exception.particle.WSInvalidParticleException;
import com.degoos.wetsponge.particle.WSParticle;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class WSParticles {
    private static Map<String, WSParticle> particleEffects = new HashMap<String, WSParticle>();
    public static final WSParticle ANGRY_VILLAGER = WSParticles.of("VILLAGER_ANGRY", "angryVillager", "minecraft:angry_villager");
    public static final WSParticle BARRIER = WSParticles.of("BARRIER", "barrier", "minecraft:barrier");
    public static final WSParticle BLOCK_CRACK = WSParticles.of("BLOCK_CRACK", "blockcrack", "minecraft:block_crack");
    public static final WSParticle BLOCK_DUST = WSParticles.of("BLOCK_DUST", "blockdust", "minecraft:block_dust");
    public static final WSParticle BUBBLE = WSParticles.of("WATER_BUBBLE", "bubble", "minecraft:water_bubble");
    public static final WSParticle CLOUD = WSParticles.of("CLOUD", "cloud", "minecraft:cloud");
    public static final WSParticle CRITIC = WSParticles.of("CRIT", "crit", "minecraft:critical_hit");
    public static final WSParticle DAMAGE_INDICATOR = WSParticles.of("DAMAGE_INDICATOR", "damageIndicator", "minecraft:damage_indicator");
    public static final WSParticle DEPTH_SUSPEND = WSParticles.of("SUSPENDED_DEPTH", "depthsuspend", "minecraft:suspended_depth");
    public static final WSParticle DRAGON_BREATH = WSParticles.of("DRAGON_BREATH", "dragonbreath", "minecraft:dragon_breath");
    public static final WSParticle DRIP_LAVA = WSParticles.of("DRIP_LAVA", "dripLava", "minecraft:drip_lava");
    public static final WSParticle DRIP_WATER = WSParticles.of("DRIP_WATER", "dripWater", "minecraft:drip_water");
    public static final WSParticle DROPLET = WSParticles.of("WATER_DROP", "droplet", "minecraft:water_drop");
    public static final WSParticle ENCHANTMENT_TABLE = WSParticles.of("ENCHANTMENT_TABLE", "enchantmenttable", "minecraft:enchanting_glyphs");
    public static final WSParticle END_ROD = WSParticles.of("END_ROD", "endRod", "minecraft:end_rod");
    public static final WSParticle EXPLODE = WSParticles.of("EXPLOSION_NORMAL", "explode", "minecraft:explosion");
    public static final WSParticle FALLING_DUST = WSParticles.of("FALLING_DUST", "fallingdust", "minecraft:falling_dust");
    public static final WSParticle FIREWORK_SPARK = WSParticles.of("FIREWORKS_SPARK", "fireworkSpark", "minecraft:fireworks_spark");
    public static final WSParticle FLAME = WSParticles.of("FLAME", "flame", "minecraft:flame");
    public static final WSParticle FOOTSTEP = WSParticles.of("FOOTSTEP", "footstep", "minecraft:footstep");
    public static final WSParticle HAPPY_VILLAGER = WSParticles.of("VILLAGER_HAPPY", "happyVillager", "minecraft:happy_villager");
    public static final WSParticle HEART = WSParticles.of("HEART", "heart", "minecraft:heart");
    public static final WSParticle HUGE_EXPLOSION = WSParticles.of("EXPLOSION_HUGE", "hugeexplosion", "minecraft:huge_explosion");
    public static final WSParticle ITEM_CRACK = WSParticles.of("ITEM_CRACK", "iconcrack", "minecraft:item_crack");
    public static final WSParticle INSTANT_SPELL = WSParticles.of("SPELL_INSTANT", "instantSpell", "minecraft:instant_spell");
    public static final WSParticle LARGE_EXPLODE = WSParticles.of("EXPLOSION_LARGE", "largeexplode", "minecraft:large_explosion");
    public static final WSParticle LARGE_SMOKE = WSParticles.of("SMOKE_LARGE", "largesmoke", "minecraft:large_smoke");
    public static final WSParticle LAVA = WSParticles.of("LAVA", "lava", "minecraft:lava");
    public static final WSParticle MAGIC_CRITIC = WSParticles.of("CRIT_MAGIC", "magicCrit", "minecraft:magic_critical_hit");
    public static final WSParticle MOB_SPELL = WSParticles.of("SPELL_MOB", "mobSpell", "minecraft:mob_spell");
    public static final WSParticle MOB_SPELL_AMBIENT = WSParticles.of("SPELL_MOB_AMBIENT", "mobSpellAmbient", "minecraft:ambient_mob_spell");
    public static final WSParticle GUARDIAN_APPEARANCE = WSParticles.of("MOB_APPEARANCE", "mobappearance", "minecraft:guardian_appearance");
    public static final WSParticle NOTE = WSParticles.of("NOTE", "note", "minecraft:note");
    public static final WSParticle PORTAL = WSParticles.of("PORTAL", "portal", "minecraft:portal");
    public static final WSParticle RED_DUST = WSParticles.of("REDSTONE", "reddust", "minecraft:redstone_dust");
    public static final WSParticle SLIME = WSParticles.of("SLIME", "slime", "minecraft:slime");
    public static final WSParticle SMOKE = WSParticles.of("SMOKE_NORMAL", "smoke", "minecraft:smoke");
    public static final WSParticle SNOWBALL_POOF = WSParticles.of("SNOWBALL", "snowballpoof", "minecraft:snowball");
    public static final WSParticle SNOW_SHOVEL = WSParticles.of("SNOW_SHOVEL", "snowshovel", "minecraft:snow_shovel");
    public static final WSParticle SPELL = WSParticles.of("SPELL", "spell", "minecraft:spell");
    public static final WSParticle SPIT = WSParticles.of("", "spit", "minecraft:split");
    public static final WSParticle SPLASH_POTION = WSParticles.of("SPIT", "splash", "minecraft:water_splash");
    public static final WSParticle SUSPENDED = WSParticles.of("SUSPENDED", "suspended", "minecraft:suspended");
    public static final WSParticle SWEEP_ATTACK = WSParticles.of("SWEEP_ATTACK", "sweepAttack", "minecraft:sweep_attack");
    public static final WSParticle TOTEM = WSParticles.of("TOTEM", "totem", "minecraft:totem");
    public static final WSParticle TOWN_AURA = WSParticles.of("TOWN_AURA", "townaura", "minecraft:town_aura");
    public static final WSParticle WAKE = WSParticles.of("WATER_WAKE", "wake", "minecraft:water_wake");
    public static final WSParticle NULL = WSParticles.of("NULL", "null", "minecraft:null");

    private static WSParticle of(String particleName, String stringId, String minecraftId) {
        try {
            WSParticle particle = BridgeParticles.of(particleName, stringId, minecraftId);
            particleEffects.put(particleName, particle);
            return particle;
        }
        catch (WSInvalidParticleException ex) {
            return NULL;
        }
    }

    public static Optional<WSParticle> getByParticleName(String name) {
        return particleEffects.keySet().stream().filter(wsParticle -> wsParticle.equalsIgnoreCase(name)).findAny().map(particleEffects::get);
    }

    public static Optional<WSParticle> getByStringId(String stringId) {
        return particleEffects.values().stream().filter(wsParticle -> wsParticle.getOldMinecraftId().equalsIgnoreCase(stringId)).findAny();
    }

    public static Optional<WSParticle> getByMinecraftId(String minecraftId) {
        return particleEffects.values().stream().filter(wsParticle -> wsParticle.getMinecraftId().equalsIgnoreCase(minecraftId)).findAny();
    }
}

