/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.particle;

import com.degoos.wetsponge.entity.living.player.Spigot13Player;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.exception.particle.WSInvalidParticleException;
import com.degoos.wetsponge.particle.WSParticle;
import com.degoos.wetsponge.resource.spigot.Spigot13ParticleEffect;
import com.degoos.wetsponge.world.Spigot13Location;
import com.degoos.wetsponge.world.WSLocation;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3f;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public class Spigot13Particle
implements WSParticle {
    private String id;
    private String minecraftId;
    private String spigotName;
    private Spigot13ParticleEffect effect;

    public Spigot13Particle(String id, String minecraftId, String spigotName) {
        this.id = id;
        this.minecraftId = minecraftId;
        this.spigotName = spigotName;
        this.effect = Spigot13ParticleEffect.fromName(id);
        if (this.effect == null) {
            throw new WSInvalidParticleException("Cannot found particle " + id + "!");
        }
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, WSPlayer ... players) {
        this.spawnParticle(location, speed, amount, new Vector3f(1.0f, 1.0f, 1.0f), players);
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, Collection<WSPlayer> players) {
        this.spawnParticle(location, speed, amount, new Vector3f(1.0f, 1.0f, 1.0f), players);
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, Vector3d playerRadius) {
        this.spawnParticle(location, speed, amount, new Vector3f(1.0f, 1.0f, 1.0f), playerRadius);
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, Vector3f radius, WSPlayer ... players) {
        this.spawnParticle(location, speed, amount, radius, Arrays.asList(players));
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, Vector3f radius, Collection<WSPlayer> players) {
        if (players.isEmpty()) {
            return;
        }
        this.effect.display((float)radius.getFloorX(), radius.getY(), radius.getZ(), speed, amount, ((Spigot13Location)location).getLocation(), players.stream().map(player -> ((Spigot13Player)player).getHandled()).collect(Collectors.toList()));
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, Vector3f radius, Vector3d playerRadius) {
        this.spawnParticle(location, speed, amount, radius, location.getNearbyPlayers(playerRadius));
    }

    @Override
    public String getOldMinecraftId() {
        return this.id;
    }

    @Override
    public String getMinecraftId() {
        return this.minecraftId;
    }

    @Override
    public String getSpigotName() {
        return this.spigotName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spigot13Particle that = (Spigot13Particle)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

