/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketWindowItems;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketWindowItems;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeSPacketWindowItems
extends SpongePacket
implements WSSPacketWindowItems {
    private int windowId;
    private List<WSItemStack> itemStacks;
    private boolean changed;

    public SpongeSPacketWindowItems(int windowsId, List<WSItemStack> itemStacks) {
        super((Packet<?>)new SPacketWindowItems());
        this.windowId = windowsId;
        this.itemStacks = itemStacks;
        this.update();
    }

    public SpongeSPacketWindowItems(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.windowId);
            fields[1].set(this.getHandler(), this.itemStacks.stream().map(item -> item == null ? null : ((SpongeItemStack)item).getHandled()).collect(Collectors.toList()));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.windowId = fields[0].getInt(this.getHandler());
            this.itemStacks = ((List)fields[1].get(this.getHandler())).stream().map(item -> item == null ? null : new SpongeItemStack((ItemStack)item).clone()).collect(Collectors.toList());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getWindowId() {
        return this.windowId;
    }

    @Override
    public void setWindowId(int windowsId) {
        this.windowId = windowsId;
        this.changed = true;
    }

    @Override
    public List<WSItemStack> getItemStacks() {
        this.changed = true;
        return this.itemStacks;
    }
}

