/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.entity.SpongeEntity;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.entity.living.player.SpongeHuman;
import com.degoos.wetsponge.entity.living.player.SpongePlayer;
import com.degoos.wetsponge.entity.living.player.WSHuman;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketSpawnPlayer;
import com.degoos.wetsponge.util.Validate;
import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSpawnPlayer;

public class SpongeSPacketSpawnPlayer
extends SpongePacket
implements WSSPacketSpawnPlayer {
    private Optional<WSLivingEntity> entity;
    private int entityId;
    private UUID uniqueId;
    private Vector3d position;
    private Vector2d rotation;
    private boolean changed;

    public SpongeSPacketSpawnPlayer(WSHuman entity) {
        super((Packet<?>)new SPacketSpawnPlayer((EntityPlayer)((SpongePlayer)entity).getHandled()));
        this.entity = Optional.ofNullable(entity);
        this.refresh();
    }

    public SpongeSPacketSpawnPlayer(WSHuman entity, Vector3d position, Vector2d rotation) {
        super((Packet<?>)new SPacketSpawnPlayer());
        this.updateEntity(entity);
        this.position = position;
        this.rotation = rotation;
        this.update();
    }

    public SpongeSPacketSpawnPlayer(Packet<?> packet) {
        super(packet);
        this.entity = Optional.empty();
        this.refresh();
    }

    public Optional<WSLivingEntity> getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(WSHuman entity) {
        Validate.notNull(entity, "Entity cannot be null!");
        this.updateEntity(entity);
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.changed = true;
        this.entityId = entityId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void setUniqueId(UUID uniqueId) {
        this.changed = true;
        this.uniqueId = uniqueId;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3d position) {
        this.changed = true;
        this.position = position;
    }

    @Override
    public Vector2d getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(Vector2d rotation) {
        this.changed = true;
        this.rotation = rotation;
    }

    private void updateEntity(WSHuman entity) {
        EntityPlayer livingBase = (EntityPlayer)((SpongeHuman)entity).getHandled();
        this.entity = Optional.ofNullable(entity);
        this.entityId = livingBase.func_145782_y();
        this.uniqueId = livingBase.func_110124_au();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[1].set(this.getHandler(), this.uniqueId);
            fields[2].setDouble(this.getHandler(), this.position.getX());
            fields[3].setDouble(this.getHandler(), this.position.getY());
            fields[4].setDouble(this.getHandler(), this.position.getZ());
            fields[5].setByte(this.getHandler(), (byte)(this.rotation.getX() * 256.0 / 360.0));
            fields[6].setByte(this.getHandler(), (byte)(this.rotation.getY() * 256.0 / 360.0));
            if (this.entity.isPresent()) {
                fields[7].set(this.getHandler(), ((EntityLivingBase)((SpongeEntity)((Object)this.entity.get())).getHandled()).func_184212_Q());
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.uniqueId = (UUID)fields[1].get(this.getHandler());
            this.position = new Vector3d(fields[2].getDouble(this.getHandler()), fields[3].getDouble(this.getHandler()), fields[4].getDouble(this.getHandler()));
            this.rotation = new Vector2d((double)fields[5].getByte(this.getHandler()) * 360.0 / 256.0, (double)fields[6].getByte(this.getHandler()) * 360.0 / 256.0);
            this.entity = Optional.empty();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

