/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.entity.SpongeEntity;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketSpawnObject;
import com.degoos.wetsponge.util.Validate;
import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSpawnObject;

public class SpongeSPacketSpawnObject
extends SpongePacket
implements WSSPacketSpawnObject {
    private Optional<WSEntity> entity;
    private int entityId;
    private UUID uniqueId;
    private Vector3d position;
    private Vector3d velocity;
    private Vector2d rotation;
    private int data;
    private int type;
    private boolean changed;

    public SpongeSPacketSpawnObject(WSEntity entity, int type, int data) {
        super((Packet<?>)new SPacketSpawnObject((Entity)((SpongeEntity)entity).getHandled(), type, data));
        this.entity = Optional.ofNullable(entity);
        this.refresh();
    }

    public SpongeSPacketSpawnObject(WSEntity entity, Vector3d position, Vector3d velocity, Vector2d rotation, int type, int data) {
        super((Packet<?>)new SPacketSpawnObject());
        this.updateEntity(entity);
        this.position = position;
        this.velocity = velocity;
        this.rotation = rotation;
        this.type = type;
        this.data = data;
        this.update();
    }

    public SpongeSPacketSpawnObject(Packet<?> packet) {
        super(packet);
        this.entity = Optional.empty();
        this.refresh();
    }

    public Optional<WSEntity> getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(WSLivingEntity entity) {
        Validate.notNull(entity, "Entity cannot be null!");
        this.updateEntity(entity);
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.changed = true;
        this.entityId = entityId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void setUniqueId(UUID uniqueId) {
        this.changed = true;
        this.uniqueId = uniqueId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.changed = true;
        this.type = type;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3d position) {
        this.changed = true;
        this.position = position;
    }

    @Override
    public Vector3d getVelocity() {
        return this.velocity;
    }

    @Override
    public void setVelocity(Vector3d velocity) {
        this.changed = true;
        this.velocity = velocity;
    }

    @Override
    public Vector2d getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(Vector2d rotation) {
        this.changed = true;
        this.rotation = rotation;
    }

    @Override
    public int getData() {
        return this.data;
    }

    @Override
    public void setData(int data) {
        this.changed = true;
        this.data = data;
    }

    private void updateEntity(WSEntity entity) {
        EntityLivingBase livingBase = (EntityLivingBase)((SpongeEntity)entity).getHandled();
        this.entity = Optional.ofNullable(entity);
        this.entityId = livingBase.func_145782_y();
        this.uniqueId = livingBase.func_110124_au();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[1].set(this.getHandler(), this.uniqueId);
            fields[2].setDouble(this.getHandler(), this.position.getX());
            fields[3].setDouble(this.getHandler(), this.position.getY());
            fields[4].setDouble(this.getHandler(), this.position.getZ());
            fields[5].setInt(this.getHandler(), (int)(this.velocity.getX() * 8000.0));
            fields[6].setInt(this.getHandler(), (int)(this.velocity.getY() * 8000.0));
            fields[7].setInt(this.getHandler(), (int)(this.velocity.getZ() * 8000.0));
            fields[8].setInt(this.getHandler(), (int)(this.rotation.getX() * 256.0 / 360.0));
            fields[9].setInt(this.getHandler(), (int)(this.rotation.getY() * 256.0 / 360.0));
            fields[10].setInt(this.getHandler(), this.type);
            fields[11].setInt(this.getHandler(), this.data);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.uniqueId = (UUID)fields[1].get(this.getHandler());
            this.position = new Vector3d(fields[2].getDouble(this.getHandler()), fields[3].getDouble(this.getHandler()), fields[4].getDouble(this.getHandler()));
            this.velocity = new Vector3d((double)fields[5].getInt(this.getHandler()) / 8000.0, (double)fields[6].getInt(this.getHandler()) / 8000.0, (double)fields[7].getInt(this.getHandler()) / 8000.0);
            this.rotation = new Vector2d((double)fields[8].getInt(this.getHandler()) * 360.0 / 256.0, (double)fields[9].getInt(this.getHandler()) * 360.0 / 256.0);
            this.type = fields[10].getInt(this.getHandler());
            this.data = fields[11].getInt(this.getHandler());
            this.entity = Optional.empty();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

