/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.entity.SpongeEntity;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketSpawnMob;
import com.degoos.wetsponge.util.Validate;
import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSpawnMob;

public class SpongeSPacketSpawnMob
extends SpongePacket
implements WSSPacketSpawnMob {
    private Optional<WSLivingEntity> entity;
    private int entityId;
    private UUID uniqueId;
    private int type;
    private Vector3d position;
    private Vector3d velocity;
    private Vector2d rotation;
    private double headPitch;
    private boolean changed;
    private WSLivingEntity disguise;

    public SpongeSPacketSpawnMob(WSLivingEntity entity) {
        super((Packet<?>)new SPacketSpawnMob((EntityLivingBase)((SpongeEntity)((Object)entity)).getHandled()));
        this.entity = Optional.ofNullable(entity);
        this.disguise = null;
        this.refresh();
    }

    public SpongeSPacketSpawnMob(WSLivingEntity entity, Vector3d position, Vector3d velocity, Vector2d rotation, double headPitch) {
        super((Packet<?>)new SPacketSpawnMob());
        this.updateEntity(entity);
        this.position = position;
        this.velocity = velocity;
        this.rotation = rotation;
        this.headPitch = headPitch;
        this.disguise = null;
        this.update();
    }

    public SpongeSPacketSpawnMob(Packet<?> packet) {
        super(packet);
        this.entity = Optional.empty();
        this.refresh();
    }

    @Override
    public Optional<WSLivingEntity> getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(WSLivingEntity entity) {
        Validate.notNull(entity, "Entity cannot be null!");
        this.updateEntity(entity);
    }

    @Override
    public Optional<WSLivingEntity> getDisguise() {
        return Optional.ofNullable(this.disguise);
    }

    @Override
    public void setDisguise(WSLivingEntity disguise) {
        Validate.notNull(disguise, "Disguise cannot be null!");
        this.changed = true;
        this.disguise = disguise;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.changed = true;
        this.entityId = entityId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void setUniqueId(UUID uniqueId) {
        this.changed = true;
        this.uniqueId = uniqueId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.changed = true;
        this.type = type;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3d position) {
        this.changed = true;
        this.position = position;
    }

    @Override
    public Vector3d getVelocity() {
        return this.velocity;
    }

    @Override
    public void setVelocity(Vector3d velocity) {
        this.changed = true;
        this.velocity = velocity;
    }

    @Override
    public Vector2d getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(Vector2d rotation) {
        this.changed = true;
        this.rotation = rotation;
    }

    @Override
    public double getHeadPitch() {
        return this.headPitch;
    }

    @Override
    public void setHeadPitch(double headPitch) {
        this.changed = true;
        this.headPitch = headPitch;
    }

    private void updateEntity(WSLivingEntity entity) {
        EntityLivingBase livingBase = (EntityLivingBase)((SpongeEntity)((Object)entity)).getHandled();
        this.entity = Optional.ofNullable(entity);
        this.entityId = livingBase.func_145782_y();
        this.uniqueId = livingBase.func_110124_au();
        this.type = EntityList.field_191308_b.func_148757_b(livingBase.getClass());
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[1].set(this.getHandler(), this.uniqueId);
            fields[2].setInt(this.getHandler(), this.disguise == null ? this.type : (int)this.disguise.getEntityType().getTypeId());
            fields[3].setDouble(this.getHandler(), this.position.getX());
            fields[4].setDouble(this.getHandler(), this.position.getY());
            fields[5].setDouble(this.getHandler(), this.position.getZ());
            fields[6].setInt(this.getHandler(), (int)(this.velocity.getX() * 8000.0));
            fields[7].setInt(this.getHandler(), (int)(this.velocity.getY() * 8000.0));
            fields[8].setInt(this.getHandler(), (int)(this.velocity.getZ() * 8000.0));
            fields[9].setByte(this.getHandler(), (byte)(this.rotation.getY() * 256.0 / 360.0));
            fields[10].setByte(this.getHandler(), (byte)(this.rotation.getX() * 256.0 / 360.0));
            fields[11].setByte(this.getHandler(), (byte)(this.headPitch * 256.0 / 360.0));
            if (this.disguise != null) {
                fields[12].set(this.getHandler(), ((EntityLivingBase)((SpongeEntity)((Object)this.disguise)).getHandled()).func_184212_Q());
            } else if (this.entity.isPresent()) {
                fields[12].set(this.getHandler(), ((EntityLivingBase)((SpongeEntity)((Object)this.entity.get())).getHandled()).func_184212_Q());
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.uniqueId = (UUID)fields[1].get(this.getHandler());
            this.type = fields[2].getInt(this.getHandler());
            this.position = new Vector3d(fields[3].getDouble(this.getHandler()), fields[4].getDouble(this.getHandler()), fields[5].getDouble(this.getHandler()));
            this.velocity = new Vector3d((double)fields[6].getInt(this.getHandler()) / 8000.0, (double)fields[7].getInt(this.getHandler()) / 8000.0, (double)fields[8].getInt(this.getHandler()) / 8000.0);
            this.rotation = new Vector2d((double)fields[10].getByte(this.getHandler()) * 360.0 / 256.0, (double)fields[9].getByte(this.getHandler()) * 360.0 / 256.0);
            this.headPitch = (double)fields[11].getByte(this.getHandler()) * 360.0 / 256.0;
            this.entity = Optional.empty();
            this.disguise = null;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

