/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketSetSlot;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeSPacketSetSlot
extends SpongePacket
implements WSSPacketSetSlot {
    private int windowId;
    private int slot;
    private WSItemStack itemStack;
    private boolean changed;

    public SpongeSPacketSetSlot(int windowsId, int slot, WSItemStack itemStack) {
        super((Packet<?>)new SPacketSetSlot());
        this.windowId = windowsId;
        this.slot = slot;
        this.itemStack = itemStack;
        this.update();
    }

    public SpongeSPacketSetSlot(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.windowId);
            fields[1].setInt(this.getHandler(), this.slot);
            fields[2].set(this.getHandler(), this.itemStack.getHandled());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.windowId = fields[0].getInt(this.getHandler());
            this.slot = fields[1].getInt(this.getHandler());
            this.itemStack = new SpongeItemStack((ItemStack)fields[2].get(this.getHandler())).clone();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getWindowId() {
        return this.windowId;
    }

    @Override
    public void setWindowId(int windowsId) {
        this.windowId = windowsId;
        this.changed = true;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public void setSlot(int slot) {
        this.slot = slot;
        this.changed = true;
    }

    @Override
    public WSItemStack getItemStack() {
        this.changed = true;
        return this.itemStack;
    }

    @Override
    public void setItemStack(WSItemStack itemStack) {
        this.itemStack = itemStack;
        this.changed = true;
    }
}

