/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.entity.SpongeEntity;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketEntityTeleport;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityTeleport;

public class SpongeSPacketEntityTeleport
extends SpongePacket
implements WSSPacketEntityTeleport {
    private int entityId;
    private Vector3d position;
    private Vector2i rotation;
    private boolean onGround;
    private boolean changed;

    public SpongeSPacketEntityTeleport(int entityId, Vector3d position, Vector2i rotation, boolean onGround) {
        super((Packet<?>)new SPacketEntityTeleport());
        this.entityId = entityId;
        this.position = position;
        this.rotation = rotation;
        this.onGround = onGround;
        this.update();
    }

    public SpongeSPacketEntityTeleport(WSEntity entity) {
        super((Packet<?>)new SPacketEntityTeleport((Entity)((SpongeEntity)entity).getHandled()));
        this.refresh();
    }

    public SpongeSPacketEntityTeleport(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.entityId = entityId;
        this.changed = true;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3d position) {
        this.position = position;
        this.changed = true;
    }

    @Override
    public Vector2i getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(Vector2i rotation) {
        this.rotation = rotation;
        this.changed = true;
    }

    @Override
    public boolean isOnGround() {
        return this.onGround;
    }

    @Override
    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
        this.changed = true;
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[1].setDouble(this.getHandler(), this.position.getX());
            fields[2].setDouble(this.getHandler(), this.position.getY());
            fields[3].setDouble(this.getHandler(), this.position.getZ());
            fields[4].setByte(this.getHandler(), (byte)((float)this.rotation.getX() * 256.0f / 360.0f));
            fields[5].setByte(this.getHandler(), (byte)((float)this.rotation.getY() * 256.0f / 360.0f));
            fields[6].setBoolean(this.getHandler(), this.onGround);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.position = new Vector3d(fields[1].getDouble(this.getHandler()), fields[2].getDouble(this.getHandler()), fields[3].getDouble(this.getHandler()));
            this.rotation = new Vector2i(fields[4].getByte(this.getHandler()) * 360 / 256, fields[5].getByte(this.getHandler()) * 360 / 256);
            this.onGround = fields[6].getBoolean(this.getHandler());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

