/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.SpongeEntity;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketEntityMetadata;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityMetadata;

public class SpongeSPacketEntityMetadata
extends SpongePacket
implements WSSPacketEntityMetadata {
    private int entityId;
    private List entries;
    private boolean changed;
    private static Field dataWatcherObject;

    public SpongeSPacketEntityMetadata(WSEntity entity) {
        super((Packet<?>)new SPacketEntityMetadata());
        Validate.notNull(entity, "Entity cannot be null!");
        this.entityId = entity.getEntityId();
        this.entries = ((Entity)((SpongeEntity)entity).getHandled()).func_184212_Q().func_187221_b();
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        this.changed = false;
        this.update();
    }

    public SpongeSPacketEntityMetadata(Packet<?> packet) {
        super(packet);
        this.changed = false;
        this.refresh();
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        if (entityId != this.entityId) {
            this.entityId = entityId;
            this.changed = true;
        }
    }

    @Override
    public void setMetadataOf(WSEntity entity) {
        Validate.notNull(entity, "Entity cannot be null!");
        this.entries = ((Entity)((SpongeEntity)entity).getHandled()).func_184212_Q().func_187221_b();
        this.changed = true;
    }

    @Override
    public void setCustomName(WSText text) {
        try {
            for (Object o : this.entries) {
                EntityDataManager.DataEntry entry = (EntityDataManager.DataEntry)o;
                if (entry.func_187205_a().func_187155_a() == 2 && (entry.func_187206_b() == null || entry.func_187206_b() instanceof String)) {
                    EntityDataManager.DataEntry stringEntry = entry;
                    stringEntry.func_187210_a((Object)text.toFormattingText());
                    break;
                }
                DataParameter parameter = (DataParameter)dataWatcherObject.get(null);
                this.entries.add(new EntityDataManager.DataEntry(parameter, (Object)(text == null ? null : text.toFormattingText())));
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was setting a custom name to a metadata packet!");
        }
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[1].set(this.getHandler(), this.entries);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.entries = (List)fields[1].get(this.getHandler());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    static {
        try {
            dataWatcherObject = WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? ReflectionUtils.setAccessible(Entity.class.getDeclaredField("field_184242_az")) : null;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was initializing a packet class!");
            dataWatcherObject = null;
        }
    }
}

