/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.enums.EnumEquipType;
import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketEntityEquipment;
import com.degoos.wetsponge.util.Validate;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEquipment;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeSPacketEntityEquipment
extends SpongePacket
implements WSSPacketEntityEquipment {
    private int entityId;
    private EnumEquipType equipType;
    private WSItemStack itemStack;
    private boolean changed;

    public SpongeSPacketEntityEquipment(int entityId, EnumEquipType equipType, WSItemStack itemStack) {
        super((Packet<?>)new SPacketEntityEquipment());
        Validate.notNull((Object)equipType, "Equip type cannot be null!");
        this.entityId = entityId;
        this.equipType = equipType;
        this.itemStack = itemStack == null ? null : itemStack.clone();
        this.changed = false;
        this.update();
    }

    public SpongeSPacketEntityEquipment(Packet<?> packet) {
        super(packet);
        this.changed = false;
        this.refresh();
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.entityId = entityId;
        this.changed = true;
    }

    @Override
    public EnumEquipType getEquipType() {
        return this.equipType;
    }

    @Override
    public void setEquipType(EnumEquipType equipType) {
        Validate.notNull((Object)equipType, "Equip type cannot be null!");
        this.equipType = equipType;
        this.changed = true;
    }

    @Override
    public WSItemStack getItemStack() {
        return this.itemStack.clone();
    }

    @Override
    public void setItemStack(WSItemStack itemStack) {
        this.itemStack = itemStack == null ? null : itemStack.clone();
        this.changed = true;
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[1].set(this.getHandler(), EntityEquipmentSlot.valueOf((String)this.equipType.name()));
            fields[2].set(this.getHandler(), this.itemStack == null ? WSItemStack.of(WSBlockTypes.AIR).getHandled() : this.itemStack.getHandled());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.itemStack = new SpongeItemStack((ItemStack)fields[2].get(this.getHandler()));
            this.equipType = EnumEquipType.getByMinecraftName(((Enum)fields[1].get(this.getHandler())).name()).orElse(EnumEquipType.MAIN_HAND);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

