/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketEntity;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntity;

public class SpongeSPacketEntity
extends SpongePacket
implements WSSPacketEntity {
    private int entityId;
    private Vector3i position;
    private Vector2i rotation;
    private boolean onGround;
    private boolean rotating;
    private boolean changed;

    public SpongeSPacketEntity(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.entityId = entityId;
        this.changed = true;
    }

    @Override
    public Vector3i getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3i position) {
        this.position = position;
        this.changed = true;
    }

    @Override
    public Vector2i getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(Vector2i rotation) {
        this.rotation = rotation;
        this.changed = true;
    }

    @Override
    public boolean isOnGround() {
        return this.onGround;
    }

    @Override
    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
        this.changed = true;
    }

    public boolean isRotating() {
        return this.rotating;
    }

    public void setRotating(boolean rotating) {
        this.rotating = rotating;
        this.changed = true;
    }

    @Override
    public void update() {
        try {
            Field[] fields = SPacketEntity.class.getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[1].setInt(this.getHandler(), this.position.getX());
            fields[2].setInt(this.getHandler(), this.position.getY());
            fields[3].setInt(this.getHandler(), this.position.getZ());
            fields[4].setByte(this.getHandler(), (byte)((double)this.rotation.getY() * 256.0 / 360.0));
            fields[5].setByte(this.getHandler(), (byte)((double)this.rotation.getX() * 256.0 / 360.0));
            fields[6].setBoolean(this.getHandler(), this.onGround);
            fields[7].setBoolean(this.getHandler(), this.rotating);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = SPacketEntity.class.getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.position = new Vector3i(fields[1].getInt(this.getHandler()), fields[2].getInt(this.getHandler()), fields[3].getInt(this.getHandler()));
            this.rotation = new Vector2i((double)fields[5].getByte(this.getHandler()) * 360.0 / 256.0, (double)fields[4].getByte(this.getHandler()) * 360.0 / 256.0);
            this.onGround = fields[6].getBoolean(this.getHandler());
            this.rotating = fields[7].getBoolean(this.getHandler());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

