/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketBlockChange;
import com.degoos.wetsponge.parser.packet.SpongePacketParser;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.flowpowered.math.vector.Vector3i;
import net.minecraft.block.state.IBlockState;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.math.BlockPos;

public class SpongeSPacketBlockChange
extends SpongePacket
implements WSSPacketBlockChange {
    private WSBlockType material;
    private Vector3i position;
    private boolean changed;

    public SpongeSPacketBlockChange(WSBlockType type, Vector3i position) {
        super((Packet<?>)new SPacketBlockChange());
        this.position = position;
        this.material = type.clone();
        this.update();
    }

    public SpongeSPacketBlockChange(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            IBlockState state = SpongePacketParser.getBlockState(this.material);
            ReflectionUtils.setFirstObject(this.getHandler().getClass(), BlockPos.class, this.getHandler(), new BlockPos(this.position.getX(), this.position.getY(), this.position.getZ()));
            ReflectionUtils.setFirstObject(this.getHandler().getClass(), IBlockState.class, this.getHandler(), state);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            BlockPos pos = ReflectionUtils.getFirstObject(SPacketBlockChange.class, BlockPos.class, this.getHandler());
            this.material = SpongePacketParser.getMaterial(ReflectionUtils.getFirstObject(SPacketBlockChange.class, IBlockState.class, this.getHandler()));
            this.position = new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.material = WSBlockTypes.AIR.getDefaultState();
            this.position = new Vector3i(0, 0, 0);
        }
    }

    @Override
    public Vector3i getBlockPosition() {
        return this.position;
    }

    @Override
    public void setBlockPosition(Vector3i position) {
        this.changed = true;
        this.position = position;
    }

    @Override
    public WSBlockType getMaterial() {
        this.changed = true;
        return this.material;
    }

    @Override
    public void setMaterial(WSBlockType material) {
        this.changed = true;
        this.material = material;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

