/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.item.SpigotItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.packet.SpigotPacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketWindowItems;
import com.degoos.wetsponge.resource.spigot.SpigotMerchantUtils;
import com.degoos.wetsponge.util.ListUtils;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SpigotSPacketWindowItems
extends SpigotPacket
implements WSSPacketWindowItems {
    private int windowId;
    private List<WSItemStack> itemStacks;
    private boolean changed;

    public SpigotSPacketWindowItems(int windowsId, List<WSItemStack> itemStacks) {
        super(NMSUtils.getNMSClass("PacketPlayOutWindowItems"));
        this.windowId = windowsId;
        this.itemStacks = itemStacks;
        this.update();
    }

    public SpigotSPacketWindowItems(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.windowId);
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                fields[1].set(this.getHandler(), this.itemStacks.stream().map(item -> item == null ? null : SpigotMerchantUtils.asNMSCopy(((SpigotItemStack)item).getHandled())).collect(Collectors.toList()));
            } else {
                fields[1].set(this.getHandler(), ListUtils.toArray(NMSUtils.getNMSClass("ItemStack"), this.itemStacks.stream().map(item -> item == null ? null : SpigotMerchantUtils.asNMSCopy(((SpigotItemStack)item).getHandled())).collect(Collectors.toList())));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.windowId = fields[0].getInt(this.getHandler());
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                this.itemStacks = ((List)fields[1].get(this.getHandler())).stream().map(item -> item == null ? null : new SpigotItemStack(SpigotMerchantUtils.asBukkitCopy(item).clone())).collect(Collectors.toList());
            } else {
                this.itemStacks = new ArrayList<WSItemStack>();
                Object[] array = (Object[])fields[1].get(this.getHandler());
                int index = 0;
                for (Object o : array) {
                    this.itemStacks.add(index, o == null ? null : new SpigotItemStack(SpigotMerchantUtils.asBukkitCopy(o).clone()));
                    ++index;
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getWindowId() {
        return this.windowId;
    }

    @Override
    public void setWindowId(int windowsId) {
        this.windowId = windowsId;
        this.changed = true;
    }

    @Override
    public List<WSItemStack> getItemStacks() {
        this.changed = true;
        return this.itemStacks;
    }
}

