/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.living.SpigotLivingEntity;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.packet.SpigotPacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketSpawnMob;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.SpigotHandledUtils;
import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class SpigotSPacketSpawnMob
extends SpigotPacket
implements WSSPacketSpawnMob {
    private Optional<WSLivingEntity> entity;
    private int entityId;
    private UUID uniqueId;
    private int type;
    private Vector3d position;
    private Vector3d velocity;
    private Vector2d rotation;
    private double headPitch;
    private boolean changed;
    private WSLivingEntity disguise;

    public SpigotSPacketSpawnMob(WSLivingEntity entity) throws InstantiationException, IllegalAccessException {
        this(entity, entity.getLocation().toVector3d(), entity.getVelocity(), entity.getRotation().toVector2(), entity.getHeadRotation().getY());
    }

    public SpigotSPacketSpawnMob(WSLivingEntity entity, Vector3d position, Vector3d velocity, Vector2d rotation, double headPitch) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutSpawnEntityLiving").newInstance());
        this.updateEntity(entity);
        this.position = position;
        this.velocity = velocity;
        this.rotation = rotation;
        this.headPitch = headPitch;
        this.disguise = null;
        this.update();
    }

    public SpigotSPacketSpawnMob(Object packet) {
        super(packet);
        this.entity = Optional.empty();
        this.disguise = null;
        this.refresh();
    }

    @Override
    public Optional<WSLivingEntity> getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(WSLivingEntity entity) {
        Validate.notNull(entity, "Entity cannot be null!");
        this.updateEntity(entity);
    }

    @Override
    public Optional<WSLivingEntity> getDisguise() {
        return Optional.ofNullable(this.disguise);
    }

    @Override
    public void setDisguise(WSLivingEntity disguise) {
        Validate.notNull(disguise, "Disguise cannot be null!");
        this.changed = true;
        this.disguise = disguise;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.changed = true;
        this.entityId = entityId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void setUniqueId(UUID uniqueId) {
        this.changed = true;
        this.uniqueId = uniqueId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.changed = true;
        this.type = type;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3d position) {
        this.changed = true;
        this.position = position;
    }

    @Override
    public Vector3d getVelocity() {
        return this.velocity;
    }

    @Override
    public void setVelocity(Vector3d velocity) {
        this.changed = true;
        this.velocity = velocity;
    }

    @Override
    public Vector2d getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(Vector2d rotation) {
        this.changed = true;
        this.rotation = rotation;
    }

    @Override
    public double getHeadPitch() {
        return this.headPitch;
    }

    @Override
    public void setHeadPitch(double headPitch) {
        this.changed = true;
        this.headPitch = headPitch;
    }

    private void updateEntity(WSLivingEntity entity) {
        Class<?> entityTypesClass = NMSUtils.getNMSClass("EntityTypes");
        LivingEntity spigotEntity = ((SpigotLivingEntity)entity).getHandled();
        Object livingBase = SpigotHandledUtils.getEntityHandle((Entity)spigotEntity);
        this.entity = Optional.ofNullable(entity);
        this.entityId = entity.getEntityId();
        this.uniqueId = spigotEntity.getUniqueId();
        if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            try {
                Object registry = entityTypesClass.getField("b").get(null);
                this.type = (Integer)ReflectionUtils.getMethod(registry.getClass(), "a", NMSUtils.getNMSClass("Entity").getClass()).invoke(registry, livingBase.getClass());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                Field field = entityTypesClass.getDeclaredField("f");
                field.setAccessible(true);
                this.type = (Integer)ReflectionUtils.getMethodByName(Map.class, "get").invoke(field.get(null), livingBase.getClass());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                fields[0].setInt(this.getHandler(), this.entityId);
                fields[1].set(this.getHandler(), this.uniqueId);
                fields[2].setInt(this.getHandler(), this.disguise == null ? this.type : (int)this.disguise.getEntityType().getTypeId());
                fields[3].setDouble(this.getHandler(), this.position.getX());
                fields[4].setDouble(this.getHandler(), this.position.getY());
                fields[5].setDouble(this.getHandler(), this.position.getZ());
                fields[6].setInt(this.getHandler(), (int)(this.velocity.getX() * 8000.0));
                fields[7].setInt(this.getHandler(), (int)(this.velocity.getY() * 8000.0));
                fields[8].setInt(this.getHandler(), (int)(this.velocity.getZ() * 8000.0));
                fields[9].setByte(this.getHandler(), (byte)(this.rotation.getY() * 256.0 / 360.0));
                fields[10].setByte(this.getHandler(), (byte)(this.rotation.getX() * 256.0 / 360.0));
                fields[11].setByte(this.getHandler(), (byte)(this.headPitch * 256.0 / 360.0));
                if (this.disguise != null) {
                    LivingEntity spigotEntity = ((SpigotLivingEntity)this.disguise).getHandled();
                    Object livingBase = SpigotHandledUtils.getEntityHandle((Entity)spigotEntity);
                    fields[12].set(this.getHandler(), ReflectionUtils.getMethod(livingBase.getClass(), "getDataWatcher", new Class[0]).invoke(livingBase, new Object[0]));
                } else if (this.entity.isPresent()) {
                    LivingEntity spigotEntity = ((SpigotLivingEntity)this.entity.get()).getHandled();
                    Object livingBase = SpigotHandledUtils.getEntityHandle((Entity)spigotEntity);
                    fields[12].set(this.getHandler(), ReflectionUtils.getMethod(livingBase.getClass(), "getDataWatcher", new Class[0]).invoke(livingBase, new Object[0]));
                }
            } else {
                fields[0].setInt(this.getHandler(), this.entityId);
                fields[1].setInt(this.getHandler(), this.type);
                fields[2].setInt(this.getHandler(), this.floor(this.position.getX() * 32.0));
                fields[3].setInt(this.getHandler(), this.floor(this.position.getY() * 32.0));
                fields[4].setInt(this.getHandler(), this.floor(this.position.getZ() * 32.0));
                double max = 3.9;
                double x = this.velocity.getX();
                double y = this.velocity.getY();
                double z = this.velocity.getZ();
                if (x < -max) {
                    x = -max;
                }
                if (y < -max) {
                    y = -max;
                }
                if (z < -max) {
                    z = -max;
                }
                if (x > max) {
                    x = max;
                }
                if (y > max) {
                    y = max;
                }
                if (z > max) {
                    z = max;
                }
                fields[5].setInt(this.getHandler(), (int)(x * 8000.0));
                fields[6].setInt(this.getHandler(), (int)(y * 8000.0));
                fields[7].setInt(this.getHandler(), (int)(z * 8000.0));
                fields[8].setByte(this.getHandler(), (byte)(this.rotation.getX() * 256.0 / 360.0));
                fields[9].setByte(this.getHandler(), (byte)(this.rotation.getY() * 256.0 / 360.0));
                fields[10].setByte(this.getHandler(), (byte)(this.headPitch * 256.0 / 360.0));
                if (this.disguise != null) {
                    LivingEntity spigotEntity = ((SpigotLivingEntity)this.disguise).getHandled();
                    Object livingBase = SpigotHandledUtils.getEntityHandle((Entity)spigotEntity);
                    fields[11].set(this.getHandler(), ReflectionUtils.getMethod(livingBase.getClass(), "getDataWatcher", new Class[0]).invoke(livingBase, new Object[0]));
                } else if (this.entity.isPresent()) {
                    LivingEntity spigotEntity = ((SpigotLivingEntity)this.entity.get()).getHandled();
                    Object livingBase = SpigotHandledUtils.getEntityHandle((Entity)spigotEntity);
                    fields[11].set(this.getHandler(), ReflectionUtils.getMethod(livingBase.getClass(), "getDataWatcher", new Class[0]).invoke(livingBase, new Object[0]));
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                this.entityId = fields[0].getInt(this.getHandler());
                this.uniqueId = (UUID)fields[1].get(this.getHandler());
                this.type = fields[2].getInt(this.getHandler());
                this.position = new Vector3d(fields[3].getDouble(this.getHandler()), fields[4].getDouble(this.getHandler()), fields[5].getDouble(this.getHandler()));
                this.velocity = new Vector3d((double)fields[6].getInt(this.getHandler()) / 8000.0, (double)fields[7].getInt(this.getHandler()) / 8000.0, (double)fields[8].getInt(this.getHandler()) / 8000.0);
                this.rotation = new Vector2d((double)fields[10].getByte(this.getHandler()) * 360.0 / 256.0, (double)fields[9].getByte(this.getHandler()) * 360.0 / 256.0);
                this.headPitch = (double)fields[11].getByte(this.getHandler()) * 360.0 / 256.0;
            } else {
                this.entityId = fields[0].getInt(this.getHandler());
                this.uniqueId = null;
                this.type = fields[1].getInt(this.getHandler());
                this.position = new Vector3d((double)fields[2].getInt(this.getHandler()) / 32.0, (double)fields[3].getInt(this.getHandler()) / 32.0, (double)fields[4].getInt(this.getHandler()) / 32.0);
                this.velocity = new Vector3d((double)fields[5].getInt(this.getHandler()) / 8000.0, (double)fields[6].getInt(this.getHandler()) / 8000.0, (double)fields[7].getInt(this.getHandler()) / 8000.0);
                this.rotation = new Vector2d((double)fields[9].getByte(this.getHandler()) * 360.0 / 256.0, (double)fields[8].getByte(this.getHandler()) * 360.0 / 256.0);
                this.headPitch = (double)fields[10].getByte(this.getHandler()) * 360.0 / 256.0;
            }
            this.disguise = null;
            this.entity = Optional.empty();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    private int floor(double var0) {
        int var2 = (int)var0;
        return var0 < (double)var2 ? var2 - 1 : var2;
    }
}

