/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumMapDecorationType;
import com.degoos.wetsponge.enums.EnumMapScale;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.map.WSMapDecoration;
import com.degoos.wetsponge.map.WSMapView;
import com.degoos.wetsponge.packet.SpigotPacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketMaps;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.flowpowered.math.vector.Vector2i;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SpigotSPacketMaps
extends SpigotPacket
implements WSSPacketMaps {
    private int mapId;
    private Vector2i origin;
    private Vector2i size;
    private WSMapView mapView;
    private boolean changed;

    public SpigotSPacketMaps(int mapId, Vector2i origin, Vector2i size, WSMapView mapView) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutMap").newInstance());
        Validate.notNull(origin, "Origin cannot be null!");
        Validate.notNull(size, "Size cannot be null!");
        Validate.notNull(mapView, "MapView cannot be null!");
        this.mapId = mapId;
        this.origin = origin;
        this.size = size;
        this.mapView = mapView;
        this.update();
    }

    public SpigotSPacketMaps(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.mapId);
            fields[1].setByte(this.getHandler(), this.mapView.getMapScale().getId());
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                fields[2].setBoolean(this.getHandler(), this.mapView.isTrackingPositions());
                fields[3].set(this.getHandler(), this.toMapDecoration(this.mapView.getAllDecorations()));
                fields[4].setInt(this.getHandler(), this.origin.getX());
                fields[5].setInt(this.getHandler(), this.origin.getY());
                fields[6].setInt(this.getHandler(), this.size.getX());
                fields[7].setInt(this.getHandler(), this.size.getY());
                fields[8].set(this.getHandler(), this.mapView.getColors());
            } else {
                fields[7].set(this.getHandler(), this.mapView.getColors());
                fields[2].set(this.getHandler(), this.toMapDecoration(this.mapView.getAllDecorations()));
                fields[3].setInt(this.getHandler(), this.origin.getX());
                fields[4].setInt(this.getHandler(), this.origin.getY());
                fields[5].setInt(this.getHandler(), this.size.getX());
                fields[6].setInt(this.getHandler(), this.size.getY());
            }
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was updating the packet SpigotSPacketMaps!");
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.mapId = fields[0].getInt(this.getHandler());
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                this.origin = new Vector2i(fields[4].getInt(this.getHandler()), fields[5].getInt(this.getHandler()));
                this.size = new Vector2i(fields[6].getInt(this.getHandler()), fields[7].getInt(this.getHandler()));
                byte[] colors = (byte[])fields[8].get(this.getHandler());
                if (colors.length == 16384) {
                    this.mapView = new WSMapView(colors, this.toWSMapDecoration(fields[3].get(this.getHandler())), fields[2].getBoolean(this.getHandler()), EnumMapScale.getById(fields[1].getByte(this.getHandler())).orElse(EnumMapScale.CLOSEST));
                }
            } else {
                this.origin = new Vector2i(fields[3].getInt(this.getHandler()), fields[4].getInt(this.getHandler()));
                this.size = new Vector2i(fields[5].getInt(this.getHandler()), fields[6].getInt(this.getHandler()));
                byte[] colors = (byte[])fields[7].get(this.getHandler());
                if (colors.length == 16384) {
                    this.mapView = new WSMapView(colors, this.toWSMapDecoration(fields[2].get(this.getHandler())), false, EnumMapScale.getById(fields[1].getByte(this.getHandler())).orElse(EnumMapScale.CLOSEST));
                }
            }
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was refreshing the packet SpigotSPacketMaps!");
        }
    }

    private Object toMapDecoration(Collection<WSMapDecoration> decorations) {
        Class<?> clazz = NMSUtils.getNMSClass("MapIcon");
        Object array = Array.newInstance(clazz, decorations.size());
        try {
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                Class<?> type = NMSUtils.getNMSClass("MapIcon$Type");
                Constructor<?> constructor = clazz.getConstructor(type, Byte.TYPE, Byte.TYPE, Byte.TYPE);
                int i = 0;
                for (WSMapDecoration decoration : decorations) {
                    Array.set(array, i, constructor.newInstance(Enum.valueOf(type, decoration.getType().name()), (byte)decoration.getPosition().getX(), (byte)decoration.getPosition().getY(), (byte)decoration.getRotation()));
                    ++i;
                }
            } else {
                Constructor<?> constructor = clazz.getConstructor(Byte.TYPE, Byte.TYPE, Byte.TYPE, Byte.TYPE);
                int i = 0;
                for (WSMapDecoration decoration : decorations) {
                    Array.set(array, i, constructor.newInstance(decoration.getType().getId(), (byte)decoration.getPosition().getX(), (byte)decoration.getPosition().getY(), (byte)decoration.getRotation()));
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was updating the packet SpigotSPacketMaps!");
        }
        return array;
    }

    private Set<WSMapDecoration> toWSMapDecoration(Object object) {
        HashSet<WSMapDecoration> decorations = new HashSet<WSMapDecoration>();
        Field[] fields = NMSUtils.getNMSClass("MapIcon").getDeclaredFields();
        Arrays.stream(fields).forEach(field -> field.setAccessible(true));
        try {
            int length = Array.getLength(object);
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                Class<?> type = NMSUtils.getNMSClass("MapIcon$Type");
                for (int i = 0; i < length; ++i) {
                    Object decoration = Array.get(object, i);
                    Object t = fields[0].get(decoration);
                    decorations.add(new WSMapDecoration(new Vector2i(fields[1].getByte(decoration), fields[2].getByte(decoration)), EnumMapDecorationType.getById(((Byte)type.getMethod("a", new Class[0]).invoke(t, new Object[0])).byteValue()).orElse(EnumMapDecorationType.PLAYER), fields[3].getByte(decoration)));
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    Object decoration = Array.get(object, i);
                    decorations.add(new WSMapDecoration(new Vector2i(fields[1].getByte(decoration), fields[2].getByte(decoration)), EnumMapDecorationType.getById(fields[0].getByte(decoration)).orElse(EnumMapDecorationType.PLAYER), fields[3].getByte(decoration)));
                }
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was refreshing the packet SpigotSPacketMaps!");
        }
        return decorations;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getMapId() {
        return this.mapId;
    }

    @Override
    public void setMapId(int id) {
        this.mapId = id;
        this.changed = true;
    }

    @Override
    public Vector2i getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Vector2i origin) {
        this.origin = origin;
        this.changed = true;
    }

    @Override
    public Vector2i setSize() {
        return this.size;
    }

    @Override
    public void setSize(Vector2i size) {
        this.size = size;
        this.changed = true;
    }

    @Override
    public WSMapView getMapView() {
        this.changed = true;
        return this.mapView;
    }

    @Override
    public void setMapView(WSMapView mapView) {
        this.mapView = mapView;
        this.changed = true;
    }
}

