/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.packet.Spigot13Packet;
import com.degoos.wetsponge.packet.play.server.WSSPacketSignEditorOpen;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Field;
import java.util.Arrays;

public class Spigot13SPacketSignEditorOpen
extends Spigot13Packet
implements WSSPacketSignEditorOpen {
    private Vector3d position;
    private boolean changed;

    public Spigot13SPacketSignEditorOpen(Vector3d position) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutOpenSignEditor").newInstance());
        Validate.notNull(position, "Position cannot be null!");
        this.position = position;
        this.update();
    }

    public Spigot13SPacketSignEditorOpen(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].set(this.getHandler(), Spigot13HandledUtils.getBlockPosition(this.position));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            Object blockPos = fields[0].get(this.getHandler());
            this.position = new Vector3d(((Integer)blockPos.getClass().getMethod("getX", new Class[0]).invoke(blockPos, new Object[0])).intValue(), ((Integer)blockPos.getClass().getMethod("getY", new Class[0]).invoke(blockPos, new Object[0])).intValue(), ((Integer)blockPos.getClass().getMethod("getZ", new Class[0]).invoke(blockPos, new Object[0])).intValue());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3d position) {
        Validate.notNull(position, "Position cannot be null!");
        this.position = position;
        this.changed = true;
    }
}

