/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.item.Spigot13ItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.packet.Spigot13Packet;
import com.degoos.wetsponge.packet.play.server.WSSPacketSetSlot;
import com.degoos.wetsponge.resource.spigot.Spigot13MerchantUtils;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.bukkit.inventory.ItemStack;

public class Spigot13SPacketSetSlot
extends Spigot13Packet
implements WSSPacketSetSlot {
    private int windowId;
    private int slot;
    private WSItemStack itemStack;
    private boolean changed;

    public Spigot13SPacketSetSlot(int windowsId, int slot, WSItemStack itemStack) {
        super(NMSUtils.getNMSClass("PacketPlayOutSetSlot"));
        this.windowId = windowsId;
        this.slot = slot;
        this.itemStack = itemStack;
        this.update();
    }

    public Spigot13SPacketSetSlot(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.windowId);
            fields[1].setInt(this.getHandler(), this.slot);
            fields[2].set(this.getHandler(), Spigot13MerchantUtils.asNMSCopy((ItemStack)this.itemStack.getHandled()));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.windowId = fields[0].getInt(this.getHandler());
            this.slot = fields[1].getInt(this.getHandler());
            this.itemStack = new Spigot13ItemStack(Spigot13MerchantUtils.asBukkitCopy(fields[2].get(this.getHandler())).clone());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getWindowId() {
        return this.windowId;
    }

    @Override
    public void setWindowId(int windowsId) {
        this.windowId = windowsId;
        this.changed = true;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public void setSlot(int slot) {
        this.slot = slot;
        this.changed = true;
    }

    @Override
    public WSItemStack getItemStack() {
        this.changed = true;
        return this.itemStack;
    }

    @Override
    public void setItemStack(WSItemStack itemStack) {
        this.itemStack = itemStack;
        this.changed = true;
    }
}

