/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.packet.Spigot13Packet;
import com.degoos.wetsponge.packet.play.server.WSSPacketMultiBlockChange;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class Spigot13SPacketMultiBlockChange
extends Spigot13Packet
implements WSSPacketMultiBlockChange {
    private Vector2i chunkPosition;
    private Map<Vector3i, WSBlockType> materials;
    private int index;
    private boolean changed;

    public Spigot13SPacketMultiBlockChange(Vector2i chunkPosition, Map<Vector3i, WSBlockType> materials) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutMultiBlockChange").newInstance());
        this.chunkPosition = chunkPosition;
        this.materials = materials;
        this.update();
    }

    public Spigot13SPacketMultiBlockChange(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public Vector2i getChunkPosition() {
        return this.chunkPosition;
    }

    @Override
    public void setChunkPosition(Vector2i chunkPosition) {
        this.changed = true;
        this.chunkPosition = chunkPosition;
    }

    @Override
    public Map<Vector3i, WSBlockType> getMaterials() {
        this.changed = true;
        return this.materials;
    }

    @Override
    public void setMaterials(Map<Vector3i, WSBlockType> materials) {
        this.changed = true;
        this.materials = materials;
    }

    @Override
    public void removeMaterial(Vector3i position) {
        this.changed = true;
        this.materials.remove(position);
    }

    @Override
    public void addMaterial(Vector3i position, WSBlockType type) {
        this.changed = true;
        this.materials.put(position, type);
    }

    @Override
    public void update() {
        this.index = 0;
        try {
            Class<?> chunkPosClass = NMSUtils.getNMSClass("ChunkCoordIntPair");
            Class<?> packetClass = NMSUtils.getNMSClass("PacketPlayOutMultiBlockChange");
            Class<?> blockUpdateDataClass = packetClass.getDeclaredClasses()[0];
            Class<?> blockStateClass = NMSUtils.getNMSClass("IBlockData");
            ReflectionUtils.setFirstObject(packetClass, chunkPosClass, this.getHandler(), chunkPosClass.getConstructor(Integer.TYPE, Integer.TYPE).newInstance(this.chunkPosition.getX(), this.chunkPosition.getY()));
            Object data = Array.newInstance(blockUpdateDataClass, this.materials.size());
            Constructor<?> constructor = blockUpdateDataClass.getConstructor(packetClass, Short.TYPE, blockStateClass);
            constructor.setAccessible(true);
            this.materials.forEach((vector3i, type) -> {
                try {
                    short offset = (short)(vector3i.getX() << 12 & 0xF000 | vector3i.getY() & 0xFF | vector3i.getZ() << 8 & 0xF00);
                    Object state = Spigot13HandledUtils.getBlockState(type);
                    Array.set(data, this.index, constructor.newInstance(this.getHandler(), offset, state));
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                ++this.index;
            });
            ReflectionUtils.setFirstObject(packetClass, data.getClass(), this.getHandler(), data);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Class<?> chunkPosClass = NMSUtils.getNMSClass("ChunkCoordIntPair");
            Class<?> packetClass = NMSUtils.getNMSClass("PacketPlayOutMultiBlockChange");
            Class<?> blockUpdateDataClass = packetClass.getDeclaredClasses()[0];
            Object blocks = ReflectionUtils.getFirstObject(packetClass, Class.forName("[L" + blockUpdateDataClass.getName() + ";"), this.getHandler());
            Object pos = ReflectionUtils.getFirstObject(packetClass, chunkPosClass, this.getHandler());
            this.chunkPosition = new Vector2i(pos.getClass().getField("x").getInt(pos), pos.getClass().getField("z").getInt(pos));
            this.materials = new HashMap<Vector3i, WSBlockType>();
            int length = Array.getLength(blocks);
            for (int i = 0; i < length; ++i) {
                Object data = Array.get(blocks, i);
                Vector3i blockPos = Spigot13HandledUtils.getBlockPositionVector(data.getClass().getMethod("a", new Class[0]).invoke(data, new Object[0])).sub(this.chunkPosition.getX() * 16, 0, this.chunkPosition.getY() * 16);
                this.materials.put(blockPos, Spigot13HandledUtils.getMaterial(data.getClass().getMethod("c", new Class[0]).invoke(data, new Object[0])));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

