/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.Spigot13Entity;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.packet.Spigot13Packet;
import com.degoos.wetsponge.packet.play.server.WSSPacketEntityMetadata;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import com.degoos.wetsponge.util.reflection.Spigot13TextUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Entity;

public class Spigot13SPacketEntityMetadata
extends Spigot13Packet
implements WSSPacketEntityMetadata {
    private int entityId;
    private List entries;
    private boolean changed;
    private static final Class<?> ITEM_CLASS = NMSUtils.getNMSClass("DataWatcher$Item");
    private static Field dataWatcherObject;

    public Spigot13SPacketEntityMetadata(WSEntity entity) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutEntityMetadata").newInstance());
        Validate.notNull(entity, "Entity cannot be null!");
        this.entityId = entity.getEntityId();
        this.entries = this.getEntityMetadata(((Spigot13Entity)entity).getHandled());
        if (this.entries == null) {
            this.entries = this.createListOfType(ITEM_CLASS);
        }
        this.changed = false;
        this.update();
    }

    public Spigot13SPacketEntityMetadata(Object packet) {
        super(packet);
        this.changed = false;
        this.refresh();
        if (this.entries == null) {
            this.entries = this.createListOfType(ITEM_CLASS);
        }
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        if (entityId != this.entityId) {
            this.entityId = entityId;
            this.changed = true;
        }
    }

    @Override
    public void setMetadataOf(WSEntity entity) {
        Validate.notNull(entity, "Entity cannot be null!");
        this.entries = this.getEntityMetadata(((Spigot13Entity)entity).getHandled());
        this.changed = true;
    }

    @Override
    public void setCustomName(WSText text) {
        try {
            for (Object o : this.entries) {
                Class<?> clazz = o.getClass();
                Object key = clazz.getMethod("a", new Class[0]).invoke(o, new Object[0]);
                int i = (Integer)key.getClass().getMethod("a", new Class[0]).invoke(key, new Object[0]);
                if (i != 2) continue;
                ReflectionUtils.setAccessible(clazz.getDeclaredField("b")).set(o, Optional.ofNullable(text == null ? null : text.toFormattingText()).map(Spigot13TextUtils::toIChatBaseComponentFromFormattedText));
                break;
            }
            Object watcherObject = dataWatcherObject.get(null);
            this.entries.add(ITEM_CLASS.getConstructors()[0].newInstance(watcherObject, Optional.ofNullable(text == null ? null : text.toFormattingText()).map(Spigot13TextUtils::toIChatBaseComponentFromFormattedText)));
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was setting a custom name to a metadata packet!");
        }
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[1].set(this.getHandler(), this.entries);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.entries = (List)fields[1].get(this.getHandler());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    private List<?> getEntityMetadata(Entity entity) {
        try {
            Object handle = Spigot13HandledUtils.getHandle(entity);
            Object watcher = NMSUtils.getNMSClass("Entity").getMethod("getDataWatcher", new Class[0]).invoke(handle, new Object[0]);
            return (List)NMSUtils.getNMSClass("DataWatcher").getMethod("b", new Class[0]).invoke(watcher, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private <T> List<T> createListOfType(Class<T> type) {
        return new ArrayList();
    }

    static {
        try {
            dataWatcherObject = WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? ReflectionUtils.setAccessible(NMSUtils.getNMSClass("Entity").getDeclaredField("aE")) : null;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was initializing a packet class!");
            dataWatcherObject = null;
        }
    }
}

